/****************************************************************************

 File:    superspinbox.h
 Created: by Aidan Lane, January  02, 2004
 Updated: by Aidan Lane, February 16, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __SUPERSPINBOX_H__
#define __SUPERSPINBOX_H__


#include <qspinbox.h>
#include <qvalidator.h>

#define DEFAULT_VALUE      0.0
#define DEFAULT_MIN_VALUE  0.0
#define DEFAULT_MAX_VALUE  99.0
#define DEFAULT_STEP_VALUE 1.0


/*! \brief Inherits QSpinBox and extends it to support double-precision floating-point numbers.
 *
 * Benefits of this method of this approach: the widget looks and feels exactly
 * like the normal integer spin box.
 *
 * <strong>Note:</strong> Unlike QSpinBox, this reimplemention does NOT calculate
 * the minimum width for the widget. Instead it will expdand to fill the entrie
 * allocated area.
 */

class SuperSpinBox : public QSpinBox
{
	Q_OBJECT	// make QT's signal/slot system work

public:
	SuperSpinBox( QWidget* parent = NULL, const char* name = NULL );
	SuperSpinBox( double minValue, double maxValue, double step = DEFAULT_STEP_VALUE,
	              QWidget* parent = NULL, const char* name = NULL );

	double value() const { return d_value; }
	double minValue() const { return d_minValue; }
	double maxValue() const { return d_maxValue; }
	double lineStep() const { return d_lineStep; }

	void setMinValue( double min );
	void setMaxValue( double max );
	void setLineStep( double step );

public slots:
	virtual void setValue( double value );
	virtual void stepUp();
	virtual void stepDown();

signals:
	void valueChanged( double value );
	void valueChanged( const QString& valueText );

protected:
	double d_value;
	double d_minValue;
	double d_maxValue;
	double d_lineStep;

	virtual int mapTextToValue( bool* ok );
	virtual QString mapValueToText( int );
	virtual void valueChange();
	virtual void rangeChange();

private:
	void sharedInit();

	QDoubleValidator* validator;
};


#endif	// __SUPERSPINBOX_H__
