/****************************************************************************

 File:    supervaluelist.h
 Created: by Aidan Lane, November 25, 2003
 Updated: by Aidan Lane, February 13, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __SUPERVALUELIST_H__
#define __SUPERVALUELIST_H__


#include <qvaluelist.h>
#include <stdarg.h>


/*! \brief Inherits Qt's QValueList and provdies a more useful constructor.
 *
 * The constructor may take multiple elements to add into the list.
 */

template<class ItemType>
class SuperValueList : public QValueList<ItemType> {

public:
	/*!
	 * The first argument is the number of variable parameters of type
	 * <em>ItemType</em>.
	 *
	 * Following the first argument, <em>argc</em> values of type
	 * <em>ItemType</em> must be passed.
	 */
	SuperValueList( int argc, ... )
	{
		va_list argptr;
		ItemType item;

		va_start( argptr, argc );	// initialize argptr
		
		// Insert the elements into the list
		for ( ; argc > 0; --argc ) {
			item = va_arg( argptr, ItemType ); // get next argument
			append( item );
		}

		va_end( argptr );	// perform an "orderly" shutdown
	}

	SuperValueList() {}
};


#endif // __SUPERVALUELIST_H__
