/****************************************************************************

 File:    unsignedintparam.h
 Created: by Aidan Lane, February 13, 2004
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __UNSIGNEDINTPARAM_H__
#define __UNSIGNEDINTPARAM_H__


#include "intparam.h"

#define UNSIGNED_INTEGER_MIN 0
#define UNSIGNED_INTEGER_MAX INT_MAX
#define UNSIGNED_INTEGER_STEP 1
#define UNSIGNED_INTEGER_MAX_WIDGET_WIDTH 100


/*! \brief Represents a parameter of type <em>GLuint</em>, used both by commmands and arrays.
 *
 * This class inherits IntParam and simply modifies the min, max and step
 * values and also the maximum widget width to its own likening.
 *
 * <strong>Note:</strong> The maximum value alowed is INT_MAX, <em>NOT</em>
 * UINT_MAX. This limitation is due to the QSpinBox widget using `int'.
 * Hence, the value can range from 0..INT_MAX. This could be overcome by
 * subclassing QSpinBox, like what was done for floats and doubles with
 * SuperSpinBox.
 *
 * As an editor widget, it provides a simple integer QSpinBox.
 */

class UnsignedIntParam : public IntParam {

public:
	UnsignedIntParam( const char* formalVarName, const char* defaultValue,
		const char* exactTypeName = "GLuint" )
		: IntParam( formalVarName, defaultValue, exactTypeName,
			UNSIGNED_INTEGER_MIN, UNSIGNED_INTEGER_MAX, UNSIGNED_INTEGER_STEP,
			UNSIGNED_INTEGER_MAX_WIDGET_WIDTH ) {}
};


#endif	// __UNSIGNEDINTPARAM_H__
