################################################################################
##
## Filename:  src.pro
## Created:   by Aidan Lane, February 05, 2004
## Updated:   by Aidan Lane, March    06, 2004
## Copyright: Monash University, Clayton Campus, Australia
## Licence:   GNU GPL (General Public License) - see GPL_LICENSE.txt for details
##
################################################################################

# OPTIONS:
#
# Build glitch using the static Qt library:    qmake use-qt-static=true
#
# Don`t strip the target file:                 qmake strip-target=false
#
# Specify extra libraries to the linker:       qmake extra-libs=[LIBS]
#
# Specify directory of the static Qt library to use when `use-qt-static=true`:
#       qmake use-qt-static=true qt-static-dir=$$QMAKE_LIBDIR_QT
#
# Don`t use internal style when `use-qt-static=true` (ignored on Mac OS X):
#       qmake use-qt-static=true use-internal-style=false
#
# NOTE: The above options CAN be combined, for example:
#       qmake use-qt-static=true strip-target=false use-internal-style=false

EXACT_QT_STATIC_LIB_DIR = $$QMAKE_LIBDIR_QT
EXACT_OPENGL_INCLUDE_DIRS = $$join( QMAKE_INCDIR_OPENGL, ":" ) # this is just a default

contains( use-qt-static, true ) {
	message( "Configuration: use-qt-static=true" )

	isEmpty( qt-static-dir  ) {
		message( "Configuration: qt-static-dir=$$EXACT_QT_STATIC_LIB_DIR [default]" )
	}
	else {
		EXACT_QT_STATIC_LIB_DIR = $$member( qt-static-dir, 0 )
		message( "Configuration: qt-static-dir=$$EXACT_QT_STATIC_LIB_DIR" )
	}
}
else {
	message( "Configuration: use-qt-static=false [default]" )
}


isEmpty( extra-libs ) {
	message( "Configuration: extra-libs=(none) [default]" )
}
else {
	EXTRA_LIBS = $$join( extra-libs, " " )
	LIBS += $$EXTRA_LIBS
	message( "Configuration: extra-libs=$$EXTRA_LIBS" )
}


INTERNAL_GLUT_SOURCES += src/3rdparty/glut_subset/glut_shapes.c \
	src/3rdparty/glut_subset/glut_teapot.c
INTERNAL_GLUT_HEADERS += src/3rdparty/glut_subset/glut.h

INTERNAL_STYLE_SOURCES += src/3rdparty/plastik_style/plastik.cpp \
	src/3rdparty/plastik_style/misc.cpp \
	src/3rdparty/plastik_style/kde_subset/kstyle.cpp \
	src/3rdparty/plastik_style/kde_subset/kpixmap.cpp \
	src/3rdparty/plastik_style/kde_subset/kpixmapeffect.cpp \
	src/3rdparty/plastik_style/kde_subset/kimageeffect.cpp
INTERNAL_STYLE_HEADERS += src/3rdparty/plastik_style/plastik.h \
	src/3rdparty/plastik_style/misc.h \
	src/3rdparty/plastik_style/kde_subset/kstyle.h \
	src/3rdparty/plastik_style/kde_subset/kpixmap.h \
	src/3rdparty/plastik_style/kde_subset/kpixmapeffect.h \
	src/3rdparty/plastik_style/kde_subset/kimageeffect.h


unix {
	UI_DIR = .ui
	MOC_DIR = .moc
	OBJECTS_DIR = .obj

	QMAKE_CLEAN += $$UI_DIR/*.ui $$MOC_DIR/*.moc $$OBJECTS_DIR/*.obj

	macx {	#		--  M a c i n t o s h  --
		LIBS += -framework GLUT -l objc # Use the native GLUT library on Mac OS X
		RC_FILE += src/images/glitch.icns
	}
	else {	#       -- U N I X    X 1 1    V a r i a n t --
		CONFIG += thread
		QMAKE_INCDIR_OPENGL += $$QMAKE_INCDIR /usr/include
		EXACT_OPENGL_INCLUDE_DIRS = $$join( QMAKE_INCDIR_OPENGL, ":"):$$join( QMAKE_INCDIR_OPENGL, "/GL:")/GL
		SOURCES += $$INTERNAL_GLUT_SOURCES
		HEADERS += $$INTERNAL_GLUT_HEADERS

		# Give the static version an internal style, unless use-internal-style=false
		contains( use-qt-static, true ) {
			contains( use-internal-style, false ) {
				message( "Configuration: use-internal-style=false" )
			}
			else {
				message( "Configuration: use-internal-style=true [default]" )
				DEFINES += USE_BUILT_IN_STYLE
				SOURCES += $$INTERNAL_STYLE_SOURCES
				HEADERS += $$INTERNAL_STYLE_HEADERS
			}
		}
	}
}

TARGET = glitch

# Strip the file, if possible
!isEmpty( QMAKE_STRIP ) {
	contains( strip-target, false ) {
		message( "Configuration: strip-target=false" )
	}
	else {
		QMAKE_POST_LINK = $${QMAKE_STRIP} ${TARGET}
		message( "Configuration: strip-target=true [default]" )
	}
}


PERL = perl
CMDTREES_DIR = src/cmdtrees
GENTREE_SCRIPT = $$CMDTREES_DIR/gentree.pl
GENTITLELIST_SCRIPT = $$CMDTREES_DIR/gentitlelist.pl

CMDTREE_HEADERS = src/attribstree.h \
	src/colourtree.h \
	src/cameratree.h \
	src/disptree.h \
	src/displisttree.h \
	src/fogtree.h \
	src/gluttree.h \
	src/inittree.h \
	src/lighttree.h \
	src/materialtree.h \
	src/matrixtree.h \
	src/primitstree.h \
	src/projectiontree.h \
	src/transtree.h

CMDTREETITLELIST_HEADER = src/cmdtreetitles.h
CMDTREETITLELIST_CONFIG_FILES = $$CMDTREES_DIR/*.cfg

acmdtree.target = src/%.h
acmdtree.depends = $$CMDTREES_DIR/%.cfg
acmdtree.commands = $$PERL $$GENTREE_SCRIPT "$$EXACT_OPENGL_INCLUDE_DIRS:src/" $< $@

cmdtreetitlelist.target = $$CMDTREETITLELIST_HEADER
cmdtreetitlelist.depends = $$CMDTREE_HEADERS # Headers exist => config files exist
cmdtreetitlelist.commands = $$PERL $$GENTITLELIST_SCRIPT \
                            $$CMDTREETITLELIST_CONFIG_FILES > $$CMDTREETITLELIST_HEADER

cmdtrees.target = cmdtrees
cmdtrees.depends = $$CMDTREETITLELIST_HEADER $$CMDTREE_HEADERS

QMAKE_EXTRA_UNIX_TARGETS += acmdtree cmdtrees cmdtreetitlelist
PRE_TARGETDEPS += cmdtrees
QMAKE_CLEAN += $$CMDTREE_HEADERS $$CMDTREETITLELIST_HEADER



SOURCES	+= src/glitch.cpp \
	src/main.cpp \
	src/glscreenviewer.cpp \
	src/glworldviewer.cpp \
	src/glscene.cpp \
	src/cmdselector.cpp \
	src/cmdtreenode.cpp \
	src/glproject.cpp \
	src/cmdinstance.cpp \
	src/supertable.cpp \
	src/allcmdtrees.cpp \
	src/superspinbox.cpp \
	src/varinstance.cpp \
	src/3rdparty/qglviewer_subset/qglviewer.cpp \
	src/3rdparty/qglviewer_subset/camera.cpp \
	src/3rdparty/qglviewer_subset/manipulatedCameraFrame.cpp \
	src/3rdparty/qglviewer_subset/keyFrameInterpolator.cpp \
	src/3rdparty/qglviewer_subset/frame.cpp \
	src/3rdparty/qglviewer_subset/vec.cpp \
	src/3rdparty/qglviewer_subset/constraint.cpp \
	src/3rdparty/qglviewer_subset/quaternion.cpp \
	src/3rdparty/qglviewer_subset/manipulatedFrame.cpp \
	src/3rdparty/qglviewer_subset/spinningFrame.cpp \
	src/3rdparty/qglviewer_subset/mouseGrabber.cpp \
	src/3rdparty/qglviewer_subset/saveSnapshot.cpp
HEADERS	+= src/glitch.h \
	src/glscreenviewer.h \
	src/glworldviewer.h \
	src/glscene.h \
	src/cmdselector.h \
	src/cmdtreenode.h \
	src/cmdinstance.h \
	src/cmdparam.h \
	src/floatparam.h \
	src/clampfloatparam.h \
	src/clampdoubleparam.h \
	src/intparam.h \
	src/unsignedintparam.h \
	src/supervaluelist.h \
	src/superptrlist.h \
	src/glproject.h \
	src/doubleparam.h \
	src/enumparam.h \
	src/arrayparam.h \
	src/supertable.h \
	src/allcmdtrees.h \
	src/superspinbox.h \
	src/varinstance.h \
	src/3rdparty/qglviewer_subset/qglviewer.h \
	src/3rdparty/qglviewer_subset/camera.h \
	src/3rdparty/qglviewer_subset/manipulatedCameraFrame.h \
	src/3rdparty/qglviewer_subset/keyFrameInterpolator.h \
	src/3rdparty/qglviewer_subset/frame.h \
	src/3rdparty/qglviewer_subset/vec.h \
	src/3rdparty/qglviewer_subset/constraint.h \
	src/3rdparty/qglviewer_subset/quaternion.h \
	src/3rdparty/qglviewer_subset/manipulatedFrame.h \
	src/3rdparty/qglviewer_subset/spinningFrame.h \
	src/3rdparty/qglviewer_subset/mouseGrabber.h \
	src/3rdparty/qglviewer_subset/config.h


FORMS	= src/mainwindow.ui \
	src/aboutdialog.ui \
	src/propertiesdialog.ui
IMAGES	= src/images/exit.png \
	src/images/filenew.png \
	src/images/fileopen.png \
	src/images/view_choose.png \
	src/images/help_16x16.png \
	src/images/filesave_16x16.png \
	src/images/filesaveas_16x16.png \
	src/images/network_22x22.png \
	src/images/network_local_22x22.png \
	src/images/up_16x16.png \
	src/images/down_16x16.png \
	src/images/button_cancel_16x16.png \
	src/images/button_ok_16x16.png \
	src/images/back_16x16.png \
	src/images/forward_16x16.png \
	src/images/reload_16x16.png \
	src/images/glitch128.png \
	src/images/glitch-title.png \
	src/images/insert_table_row.png \
	src/images/delete_table_row.png
TEMPLATE	=app
CONFIG	+= qt opengl warn_on release
INCLUDEPATH	+= /usr/X11R6/include
LANGUAGE	= C++



# NOTE: The following code block MUST be positioned at the bottom of this file!
contains( use-qt-static, true ) {
	CONFIG -= qt
	CONFIG += moc
	INCLUDEPATH += $$QMAKE_INCDIR_QT
	LIBS += $$QMAKE_LIBS_OPENGL

	contains( CONFIG, thread ) {
		LIBS += $$EXACT_QT_STATIC_LIB_DIR/libqt-mt.a $$QMAKE_LIBS_THREAD
		PRE_TARGETDEPS += $$EXACT_QT_STATIC_LIB_DIR/libqt-mt.a
	}
	else {
		LIBS += $$EXACT_QT_STATIC_LIB_DIR/libqt.a
		PRE_TARGETDEPS += $$EXACT_QT_STATIC_LIB_DIR/libqt.a
	}

	unix:!macx {
		LIBS += -L$$QMAKE_LIBDIR_X11 $$QMAKE_LIBS_X11
	}
}
