/****************************************************************************

 File:    cmdinstance.h
 Created: by Aidan Lane, November 26, 2003
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __CMDINSTANCE_H__
#define __CMDINSTANCE_H__


#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qhbox.h>

#include "cmdtreenode.h"
#include "varinstance.h"
#include "cmdselector.h"


/*! \brief Represents an instance of a command.
 *
 * <strong>Note:</strong> There is a QtMac (Q_OS_MACX) specific section in the
 * CmdInstance::setEditorBackgroundColour() method.
 *
 * <strong>Note:</strong> If you want to be able to make a
 * CmdInstance::createEditorWidget() call, then you will need to make a
 * CmdInstance::setCmdSelector() call first. Though, this only needs to be done
 * once.
 */

class CmdInstance : public QObject
{
	Q_OBJECT	// make QT's signal/slot system work

public:
	CmdInstance( CmdTreeNode* cmd = NULL, bool autoInitParams = true );
	CmdInstance( CmdTreeNode* cmd, const QStringList& paramValues );
	~CmdInstance();

	// getters
	CmdTreeNode* cmd() { return myCmd; }
	const QStringList& paramValues() const { return myParamValues; }
	const QMap<uint,VarInstance*>& externVarsMap() const { return myExternVarsMap; }
	bool isEnabled() const { return myEnabledStatus; }

	// setters
	void setCmd( CmdTreeNode* cmd, bool autoInitParams = true );
	void setParamValues( const QStringList& paramValues ) { myParamValues = paramValues; }
	void setEnabled( bool enable ) { myEnabledStatus = enable; }
	
	// other
	void exec() const;
	void initParamValues();
	QString toString() const;
	void updateParamValues();

	// editor widget components
	QHBox* createEditorWidget( QWidget* parent );
	QHBox* getEditorWidget() { return cmdEditorBox; }
	void setCmdSelector( CmdSelector* selector ) { myCmdSelector = selector; }
	CmdSelector* cmdSelectoror() const { return myCmdSelector; }
	void setEditorBackgroundColour( const QColor& colour );

	void updateParamWidgets();	// update only their values

signals:
	void cmdInstanceChanged( CmdInstance* instance );
	void cmdEnabledStatusChanged( CmdInstance* instance );
	void cmdParamChanged( CmdInstance* instance );
	void varInstanceCreated( CmdInstance* instance, VarInstance* varInst );

public slots:
	void cmdSelectionChanged( CmdTreeNode* cmd );

private slots:
	void cmdSelectorClicked();
	void cmdEnableCheckBoxToggled( bool on );
	void paramValueChanged();
	void editorWidgetCleanup();

private:
	void sharedInit();
	void createParamWidgets();

	CmdTreeNode* myCmd;
	QStringList myParamValues;

	bool myEnabledStatus;

	// Value = parameter index, Key = variable instance
	QMap<uint,VarInstance*> myExternVarsMap;

	// The command selector pop-up widget - used by the editor
	CmdSelector* myCmdSelector;

	// The following are used for command selection and editing
	QHBox*            cmdEditorBox;
	QCheckBox*        cmdEnabledCheckBox;
	QLabel*           cmdSpacerLabel;
	QPushButton*      cmdSelectorButton;
	QLabel*           cmdOpenBraceLabel;
	QLabel*           cmdCloseBraceLabel;
	QHBox*            cmdParamsBox;
	QPtrList<QWidget> cmdParamWidgets;
};

#endif	// __CMDINSTANCE_H__
