/****************************************************************************

 File:    cmdtreenode.h
 Created: by Aidan Lane, November 24, 2003
 Updated: by Aidan Lane, February 14, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __CMDTREENODE_H__
#define __CMDTREENODE_H__


#include <qptrlist.h>
#include <qstringlist.h>
#include <qstring.h>

#include "cmdparam.h"
#include "superptrlist.h"


/*! \brief Represents a node of a command tree, which is either a command
 * prototype or a subtree.
 *
 * <strong>Note:</strong> There is NO cmdtree class, as the tree is entirely
 * made up of these nodes.
 *
 * <strong>Note:</strong> This uses QPtrList's autodelete on the
 * <em>mySubTree</em> and <em>myParams</em>! (if they exist)
 */

// For a sub-tree: set myFuncPtr and myParams to NULL and initialize subTree
// For a command leaf: set subTree to NULL and initialize myFuncPtr and myParams
// Note: NULL can be specified for myParams to have no myParams => ()
class CmdTreeNode {

public:
	CmdTreeNode( const QString& name, QPtrList<CmdTreeNode>* subTree = NULL,
		void (*funcPtr) (const QStringList&) = NULL,
		SuperPtrList<CmdParam>* params = NULL );
	~CmdTreeNode();

	// getters
	const QString& name() const { return myName; }
	QPtrList<CmdTreeNode>* subTree() { return mySubTree; }
	void ( *funcPtr() ) (const QStringList&) { return myFuncPtr; }
	QPtrList<CmdParam>* params() { return myParams; }

	// setters
	void setName( QString name ) { myName = name; }	
	void setSubTree( QPtrList<CmdTreeNode>* subTree ) { mySubTree = subTree; }
	void setFuncPtr( void (*funcPtr) (const QStringList&) ) { myFuncPtr = funcPtr; }
	void setParams( QPtrList<CmdParam>* params ) { myParams = params; }

	// other
	void exec( const QStringList& paramValues ) const { myFuncPtr(paramValues); }
	QString toString() const;	// get the prototype string
	
	// searching
	static CmdTreeNode* findNode( QPtrList<CmdTreeNode>* tree, QString name );

protected:
	QString myName;
	QPtrList<CmdTreeNode>* mySubTree;
	void (*myFuncPtr) (const QStringList&);
	QPtrList<CmdParam>* myParams;
};


#endif	// __CMDTREENODE_H__
