#!/usr/bin/perl
################################################################################
#
# Title:    GENTITLELIST
# Filename: gentree.pl
# Created:  by Aidan Lane, February 10, 2003
# Updated:  by Aidan Lane, February 10, 2004
# Desc:     This is designed to produce C++ header code for Glitch, regarding
#           the titles of specified command trees.
#           For each config file specified, a macro definition is created.
#           For example, if its $className = "InitTree" and its $groupTitle =
#           "Initialization", then this script will output (for this config):
#
#               #define INITTREE_TITLE  "Initialization"
#
################################################################################

print "#ifndef __CMD_TREE_TITLE_LIST__\n";
print "#define __CMD_TREE_TITLE_LIST__\n\n";

foreach ( @ARGV )
{
	# Make sure that the config file is ACTUALLY a file, which can be read from
	if ( not -r $_ ) {
		die "Error: Failed to open \"$_\" for reading from. Exiting.\n";
	}

	# Evaluate $className and $groupTitle, which are defined in the config file
	if ( not do $_ ) {
		warn "Error: The configuration file \"$_\" contains errors:\n";
		exec $^X, "$cfg_filename"; # execute the configuration script, as to diagnose it
		die "Exiting.\n"; # control should NOT reach here!
	}

	print "#define " . uc($className) . "_TITLE \"" . $groupTitle . "\"\n";
}

print "\n#endif // __CMD_TREE_TITLE_LIST__\n";
