/****************************************************************************

 File:    glitch.h
 Created: by Aidan Lane, November 19, 2003
 Updated: by Aidan Lane, February 23, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __GLITCH_H__
#define __GLITCH_H__


#include <qwidget.h>
#include <qptrlist.h>
#include <qvaluelist.h>
#include <qmap.h>

#include "mainwindow.h"
#include "glscreenviewer.h"
#include "glworldviewer.h"
#include "glscene.h"
#include "supertable.h"
#include "cmdinstance.h"
#include "varinstance.h"
#include "glproject.h"
#include "cmdtreenode.h"


#include "mainpage.h" // Doxygen Main Page


/*! \brief Inherits the MainWindow QMainWindow class to provide functionality.
 *
 * This class is in control of the entire application.
 *
 * <strong>Note:</strong> There are a few QtMac (Q_OS_MACX) specific sections
 * in this class, such as in Glitch::Glitch() and Glitch::tweekMacMenus().
 */


class Glitch : public MainWindow
{
	Q_OBJECT	// make QT's signal/slot system work

	struct VarCmdInfo {
		const CmdTreeNode* cmd;
		QPtrList<VarInstance> vars;
	};

public:
	Glitch( QString filename = QString::null );
	~Glitch();

private slots:
	virtual void cmdTableCurrentChanged( int row, int );
	virtual void insertCommand();
	virtual void removeCommand();
	virtual void moveCmdUp();
	virtual void moveCmdDown();

	virtual void cmdListTabChanged( QWidget* w );

	virtual void varTableCurrentChanged( int row, int );

	virtual void cmdInstanceUpdated( CmdInstance* instance );

	virtual void fileNew();
	virtual void fileOpen();
	virtual void fileSave();
	virtual void fileSaveAs();
	virtual void fileProperties();
	virtual void worldViewResetCamera();
	virtual void worldViewDrawAxes( bool enable );
	virtual void worldViewDrawGrid( bool enable );
	virtual void worldViewDrawFrustum( bool enable );
	virtual void worldViewDoubleBuffer( bool enable );
	virtual void worldViewDisplayZBuffer( bool enable );
	virtual void worldViewOrthoProjection( bool enable );
	virtual void worldViewPerspectiveProjection( bool enable );
	virtual void worldViewSetForegroundColour();
	virtual void worldViewSetBackgroundColour();
	virtual void screenViewKeepAspectRatio( bool enable );
	virtual void optionsRestoreOpenGLContexts();
	virtual void optionsAutoGLClear( bool enable );
	virtual void optionsAutoGLFlush( bool enable );
	virtual void optionsAutoGLEnd( bool enable );
	virtual void optionsFilterCmdLists( bool enable );
	virtual void optionsFullScreen( bool enable );
	virtual void optionsSaveOptionsOnExit( bool enable );
	virtual void optionsRestoreDefaults();
	virtual void helpAbout();

	virtual void stepDisplay( bool enable );
	virtual void stepperReset();
	virtual void stepperPrev();
	virtual void stepperNext();
	virtual void matrixSelectionClicked( int id );

	virtual void closeEvent( QCloseEvent* e );

	virtual void varInstanceCreated( CmdInstance* instance, VarInstance* varInst );
	virtual void varInstanceDestroyedCleanup( QObject* obj );
	
	virtual void updateSceneDependents();

private:
	void constructCmdTrees();
	inline void appendTree( QPtrList<CmdTreeNode>* to,
		QPtrList<CmdTreeNode>* trees, const QString& name );

	void loadOptionSettings();
	void saveOptionSettings();
	
	bool openProject( const QString& filename );
	bool saveCurrentProject( const QString& filename );

	void moveCommand( int tabIndex, int fromPos, int toPos );

	void updateStepperWidgets();
	void updateMatrixValues( bool clearValuesInstead=false );

	void updateCmdInstanceVars( CmdInstance* instance );

	bool makeVarNameUnique( VarInstance* varInst );
	QString doubleToStr( double n ) const;

	#if defined(Q_OS_MACX)
	void tweekMacMenus();
	#endif	// defined(Q_OS_MACX)

	GLProject* project;

	bool unsavedChangesExist;

	QPtrList<SuperTable> tabTables;	// enables the simplfication of code
	                                // 3 values - varsTable, initCmdsTable
	                                //            and dispCmdsTable

	QColor varSelectedColour;
	QColor cmdSelectedColour;
	QColor cmdStepPosColour;

	int matrixSelection;	// carries the ID/index of the which radio-button

	uint currInitRow;
	uint currDispRow;
	uint currVarRow;

	/* The following variables / objects are used to MANAGE variable instances
	 * (note that only CmdInstances can OWN them).
	 * It may seem stupid to have so much redundancy, but they are all used,
	 * as they enable fast-lookups throughout the program, where they will be
	 * called upon often.
	 * There purposes are detailed below:
	 */
	// Command instance -> command info (cmd tree node & its variable instances)
	QMap<CmdInstance*, VarCmdInfo> varCmdInfoMap;
	// Fast-lookup: variable instance -> command instance owner
	QMap<VarInstance*, CmdInstance*> varToCmdInstMap;
	// Used to find the table row of a variable instance (a .find(x) is used on it)
	QPtrList<VarInstance> orderedVarList;
	// Fast-lookup: variable instance NAME -> variable instance (reverse also used)
	QMap<QString, VarInstance*> uniqueVarNames;

	// the following are used to build the command trees
	QPtrList<CmdTreeNode>* allCmdTrees;
	QPtrList<CmdTreeNode>* initTrees;
	QPtrList<CmdTreeNode>* dispTrees;

	// The command selector pop-up widget - used by the editor
	CmdSelector* myCmdSelector;

	bool filterCmdLists;
	bool saveOptionsOnExit;

	// Variables that are used to manage the display stepper
	bool inStepperMode;
	int stepperPos;
	int oldStepperPos;

	GLScreenViewer* screenView;
	GLWorldViewer* worldView;

	GLScene* scene;
};


#endif	// __GLITCH_H__
