/****************************************************************************

 File:    main.cpp
 Created: by Aidan Lane, November 19, 2003
 Updated: by Aidan Lane, February 19, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#include <qapplication.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qgl.h>

#include <iostream>
#include <string>

#include "glitch.h"
#include "glproject.h"

#ifdef USE_BUILT_IN_STYLE
#include "3rdparty/plastik_style/plastik.h"
#endif // USE_BUILT_IN_STYLE

using namespace std;


int main( int argc, char **argv )
{
	char* execName = argv[0];
	bool tryFilename = false;

	// Parse the command line argument - there should only be 0 OR 1
	if ( argc > 2 ) {
		cout << "Too many command line arguments were specified." << endl
		     << "Usage: " << execName << " [PROJECT FILE]" << endl
		     << "Try `" << execName << " --help' for more information." << endl;
		return 1;
	}
	else if ( argc == 2 )	// executable name + one user specified argument = 2
	{
		if ( strcmp(argv[1], "--help") == 0 )
		{
			cout << "Usage: " << execName << " [PROJECT FILE]" << endl
			     << "The PROJECT FILE (of type *." << GLProject::fileExtension()
				 << ") is optional." << endl
			     << "Specifying --help, as you have, will print this information." << endl;
			return 0;
		}
		// Don't treat the argument as a filename if it has a '-' prefix
		else if ( argv[1][0] != '-' ) {
			tryFilename = true;	// try the argument as a filename
		}
	}

	QApplication a( argc, argv );

	#ifdef USE_BUILT_IN_STYLE
	QApplication::setStyle( new PlastikStyle );
	QPalette pal;
	QColorGroup cg;
	cg.setColor( QColorGroup::Foreground, Qt::black );
	cg.setColor( QColorGroup::Button, QColor( 225, 227, 232) );
	cg.setColor( QColorGroup::Light, Qt::white );
	cg.setColor( QColorGroup::Midlight, Qt::white );
	cg.setColor( QColorGroup::Dark, QColor( 85, 85, 85) );
	cg.setColor( QColorGroup::Mid, QColor( 199, 199, 199) );
	cg.setColor( QColorGroup::Text, Qt::black );
	cg.setColor( QColorGroup::BrightText, Qt::white );
	cg.setColor( QColorGroup::ButtonText, Qt::black );
	cg.setColor( QColorGroup::Base, Qt::white );
	cg.setColor( QColorGroup::Background, QColor( 239, 239, 239) );
	cg.setColor( QColorGroup::Shadow, Qt::black );
	cg.setColor( QColorGroup::Highlight, QColor( 249, 224, 137) );
	cg.setColor( QColorGroup::HighlightedText, Qt::black );
	cg.setColor( QColorGroup::Link, QColor( 10, 95, 137) );
	cg.setColor( QColorGroup::LinkVisited, QColor( 137, 10, 137) );
	pal.setActive( cg );
	cg.setColor( QColorGroup::Foreground, Qt::black );
	cg.setColor( QColorGroup::Button, QColor( 225, 227, 232) );
	cg.setColor( QColorGroup::Light, Qt::white );
	cg.setColor( QColorGroup::Midlight, Qt::white );
	cg.setColor( QColorGroup::Dark, QColor( 85, 85, 85) );
	cg.setColor( QColorGroup::Mid, QColor( 199, 199, 199) );
	cg.setColor( QColorGroup::Text, Qt::black );
	cg.setColor( QColorGroup::BrightText, Qt::white );
	cg.setColor( QColorGroup::ButtonText, Qt::black );
	cg.setColor( QColorGroup::Base, Qt::white );
	cg.setColor( QColorGroup::Background, QColor( 239, 239, 239) );
	cg.setColor( QColorGroup::Shadow, Qt::black );
	cg.setColor( QColorGroup::Highlight, QColor( 249, 224, 137) );
	cg.setColor( QColorGroup::HighlightedText, Qt::black );
	cg.setColor( QColorGroup::Link, QColor( 10, 95, 137) );
	cg.setColor( QColorGroup::LinkVisited, QColor( 137, 10, 137) );
	pal.setInactive( cg );
	cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
	cg.setColor( QColorGroup::Button, QColor( 225, 227, 232) );
	cg.setColor( QColorGroup::Light, Qt::white );
	cg.setColor( QColorGroup::Midlight, Qt::white );
	cg.setColor( QColorGroup::Dark, QColor( 85, 85, 85) );
	cg.setColor( QColorGroup::Mid, QColor( 199, 199, 199) );
	cg.setColor( QColorGroup::Text, QColor( 199, 199, 199) );
	cg.setColor( QColorGroup::BrightText, Qt::white );
	cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
	cg.setColor( QColorGroup::Base, Qt::white );
	cg.setColor( QColorGroup::Background, QColor( 239, 239, 239) );
	cg.setColor( QColorGroup::Shadow, Qt::black );
	cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
	cg.setColor( QColorGroup::HighlightedText, Qt::white );
	cg.setColor( QColorGroup::Link, QColor( 10, 95, 137) );
	cg.setColor( QColorGroup::LinkVisited, QColor( 137, 10, 137) );
	pal.setDisabled( cg );
	QApplication::setPalette( pal, true );
	#endif // USE_BUILT_IN_STYLE

	// Ensure that the system has OpenGL support before proceeding
	if ( !QGLFormat::hasOpenGL() ) {
		qWarning( "This system has no OpenGL support. Exiting." );
		return -1;
	}

	// Create and launch Glitch proper
	Glitch tutor( (tryFilename ? argv[1] : QString::null) );
	tutor.show();

	a.setMainWidget( &tutor );

	return a.exec();
}
