/****************************************************************************

 File:    varinstance.h
 Created: by Aidan Lane, January  08, 2004
 Updated: by Aidan Lane, February 26, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __VARINSTANCE_H__
#define __VARINSTANCE_H__


#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qhbox.h>

#include "cmdparam.h"


/*!
 * \brief Represents an instance of a variable.
 *
 * Arrays are supported, as it uses a string list for the elements.
 *
 * <strong>Note:</strong> Currently, only ARRAYS are supported, as they are the
 * only type of variable needed by Glitch (currently).
 *
 * <strong>Note:</strong> Arrays of arrays are NOT supported.
 *
 * <strong>Note:</strong> There is a QtMac (Q_OS_MACX) specific section in the
 * VarInstance::setEditorBackgroundColour() method.
 *
 * <strong>Assumption:</strong> All of the elements in extVarElements of
 * myCmdParam (set by either VarInstance::VarInstance() or
 * VarInstance::setCmdParam() MUST be of the same type!
 */

class VarInstance : public QObject
{
	Q_OBJECT	// make QT's signal/slot system work

public:
	VarInstance( const QString& name, CmdParam* cmdParam = NULL,
		bool autoInitElements = true );
	VarInstance( const QString& name, CmdParam* cmdParam,
		const QStringList& elementValues );
	
	// getters
	const QString& varName() const { return myVarName; }
	CmdParam* cmdParam() { return myCmdParam; }
	const QStringList& elementValues() const { return myElementValues; }
	// Note: There is no setter for myElementTypeName, as it is dictated by
	// myCmdParam, hence it is set by the setCmdParam method.
	const QString& elementTypeName() const { return myElementTypeName; }

	// setters
	void setVarName( const QString& name ) { myVarName = name; }
	void setCmdParam( CmdParam* cmdParam, bool autoInitElements = true );
	void setElementValues( const QStringList& values );

	// other
	void initElementValues();
	QString toString() const;

	// editor widget components
	QHBox* createEditorWidget( QWidget* parent );
	QHBox* getEditorWidget() { return varEditorBox; }
	void updateEditorWidget();
	void setEditorBackgroundColour( const QColor& colour );

signals:
	void varElementChanged();

private slots:
	void editorWidgetCleanup();
	void elementValueChanged();

private:
	void sharedInit();

	QString     myVarName;
	CmdParam*   myCmdParam;
	QStringList myElementValues;
	QString     myElementTypeName;

	// The following are used for variable editing
	QHBox*            varEditorBox;
	QLabel*           varFrontLabel;
	QLabel*           varEndLabel;
	QPtrList<QWidget> varElementWidgets;
};


#endif	// __VARINSTANCE_H__
