/****************************************************************************

 File:    arrayparam.h
 Created: by Aidan Lane, December 30, 2004
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __ARRAYPARAM_H__
#define __ARRAYPARAM_H__


#include <qlineedit.h>

#include "cmdparam.h"


/*! \brief Represents an array parameter <em>int</em>, as used by commands.
 *
 * This class inherits CmdParam to provide a parameter that has a formal
 * variable name, a default value and an exact type name.
 * Noticeably though, it has an extra property (vs intparam, floatparam,
 * etc.) for the actual elements of the array, <em>extVarElements</em>.
 * This is a list of pointers to CmdParam instances, enabling arrays of almost
 * any type to by implemented.
 *
 * As an editor widget, it provides a simple QLineEdit, which is used to
 * it the variable's name. It also relies on support from Glitch to provide
 * editor access to the external variable elements.
 *
 *<strong>Assumption:</strong> All of the elements in <em>extVarElements</em>
 *MUST be of the same type.
 */

class ArrayParam : public CmdParam {

	Q_OBJECT	// make QT's signal/slot system work

public:
	ArrayParam( const char* formalVarName, const char* defaultValue,
		SuperPtrList<CmdParam>* extVarElements,
		const char* exactTypeName = "unknown_array" )
		: CmdParam( formalVarName, defaultValue, exactTypeName, extVarElements ) {}

	// widgets
	virtual QWidget* createWidget( QWidget* parent, const char* name,
					const QObject *slotOwner, const char* member )
	{
		QLineEdit* w = new QLineEdit( parent, name );
		// NOTE: we are not connecting to the lineedit's textChanged signal, but
		// rather its returnPressed and lostFocus signals, as it can get very
		// annoying when glitch updates after EVERY keystroke, especially
		// when enforcing the unique variable name policy.
		connect( w, SIGNAL( returnPressed() ), slotOwner, member );
		connect( w, SIGNAL( lostFocus() ), slotOwner, member );
		return (QWidget*)w;
	}

	// Update the name of the array variable
	virtual void setWidgetValue( QWidget* widget, const QString& value ) {
		if ( widget != NULL )
			((QLineEdit*)widget)->setText( value );
	}

	virtual QString getWidgetValue( QWidget* widget ) {
		return (widget!=NULL) ? ((QLineEdit*)widget)->text() : QString::null;
	}
};


#endif	// __ARRAYPARAM_H__
