/****************************************************************************

 File:    cmdselector.h
 Created: by Aidan Lane, November 25, 2003
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __CMDSELECTOR_H__
#define __CMDSELECTOR_H__


#include <qapplication.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qframe.h>
#include <qhgroupbox.h>
#include <qptrlist.h>
#include <qmap.h>

#include "cmdtreenode.h"


/*! \brief Provides a popup window that contains a listvew, in which the user
 * may select a command item from.
 *
 */


class CmdSelector : public QFrame
{
	Q_OBJECT	// make QT's signal/slot system work

public:
	CmdSelector( QWidget* parent=0, const char* name=0,
					int width=-1, int height=-1 );
	
	void popup( QWidget* parent=0);
	void setCmdTree( QPtrList<CmdTreeNode>* tree );
	void selectItem( QListViewItem* item );
	void selectItem( CmdTreeNode* cmd );

signals:
	void closed();
	void cmdSelected( CmdTreeNode* );

private slots:
	void listItemClicked( QListViewItem* item );	// will emit cmdSelected
    
private:
	template<class ParentT> void insertSubtree( ParentT* parent, QPtrList<CmdTreeNode>* );
	
	QWidget* popupParent;
	QListView* cmdList;
	CmdTreeNode* currentCmd;
	// Yes, I KNOW... there is redundancy here, but it is worth it...
	QMap<QListViewItem*, CmdTreeNode*> listItemToCmd;
	QMap<CmdTreeNode*, QListViewItem*> cmdToListItem;
};


#endif	// __CMDSELECTOR_H__
