/****************************************************************************

 File:    supertable.h
 Created: by Aidan Lane, December 16, 2003
 Updated: by Aidan Lane, February 19, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __SUPERTABLE_H__
#define __SUPERTABLE_H__


#include <qtable.h>
#include <qmap.h>

/*! \brief Inherits and extends QTable to offer more features.
 *
 * Extensions to QTable includes such things as the ability to set the background
 * colour of (individual) table rows and also the ability to set whether or not
 * (individual) rows should LOOK disabled. (Note the emphasis above on LOOK, as
 * the row won't actually be disabled, you will still be able to click on it to
 * select it!)
 *
 * This class also disables the Enter and Return keys from moving the
 * current row selection to the next one. Hence, when the user presses either of
 * these keys, any focused input widgets that exist in the row will be simply
 * confirmed and validated, that is all. This makes it work the way you would
 * expect it to.
 */

class SuperTable : public QTable
{
public:
	SuperTable( QWidget* parent=NULL, const char* name=NULL );
	SuperTable( int numRows, int numCols,
	            QWidget* parent=NULL, const char* name=NULL );

	void keyPressEvent( QKeyEvent* event );
	
	void setRowBackground( uint row, bool filled, QColor c = Qt::white );
	void setRowDisabledLook( uint row, bool disabledLook );

	virtual void paintCell( QPainter* p, int row, int col, const QRect& cr,
	                        bool selected, const QColorGroup& cg );

public slots:
	virtual void setNumRows( int rows );
	virtual void removeRow( int row );
	virtual void removeRows( const QMemArray<int>& rows );

private:
	QMap<int, QColor> rowBkgrndColourMap;	// alternative background colours
	QMap<int, bool>   rowDisabledLookMap;
};


#endif // __SUPERTABLE_H__
