// MONASH UNIVERSITY
// Clayton School of Information Technology
// CSE2305 Object Oriented Software Engineering
//
// List.C
//

#include "List.h"

///////////////////////////////////////////////////////////////////////////////
// List::Node
///////////////////////////////////////////////////////////////////////////////

List::Node::Node(const DataType& data, Node* next) : myData(data), myNext(next)
{
}

DataType List::Node::GetData(void)
{
	return myData;
}

void List::Node::SetData(const DataType& data)
{
	myData = data;
}

List::Node* List::Node::GetNext(void)
{
	return myNext;
}
	
void List::Node::SetNext(Node* next)
{
	myNext = next;
}
	
///////////////////////////////////////////////////////////////////////////////
// List
///////////////////////////////////////////////////////////////////////////////

List::List(void) : myCurrent(0), myPrevious(0), myHead(0)
{
}

bool List::Insert(const DataType& data)
{
	if (myPrevious != 0)
	{
		myCurrent = new Node(data,myCurrent);
		myPrevious->SetNext(myCurrent);
	}
	else
	{
		myHead = new Node(data,myHead);
		myCurrent = myHead;
	}
	return true;
}

bool List::First(void)
{
	myPrevious = 0;
	myCurrent = myHead;
	return myCurrent != 0;
}

bool List::Next(void)
{
	if (myCurrent != 0)
	{
		myPrevious = myCurrent;
		myCurrent = myCurrent->GetNext();
	}
	return myCurrent != 0;
}

bool List::GetCurrent(DataType& data)
{
	if (myCurrent==0) { return false; }
	data = myCurrent->GetData();
	return true;
}

bool List::SetCurrent(const DataType& data)
{
	if (myCurrent==0) { return false; }
	myCurrent->SetData(data);
	return true;
}
