#ifndef _CLS_LIST_
#define _CLS_LIST_

// MONASH UNIVERSITY
// Clayton School of Information Technology
// CSE2305 Object Oriented Software Engineering
//
// List.h
//

#include <string>
#include <iostream>

// select namespace std for strings and IO
using namespace std;

typedef string DataType;

class List
{
 private:
	class Node
	{
	 public:
		Node(const DataType& data, Node* next);
		DataType GetData(void);
		void SetData(const DataType& data);
		Node* GetNext(void);
		void SetNext(Node* next);
	
	 private:
		DataType myData;
		Node*    myNext;
	};

 public:
	List(void);
	bool Insert(const DataType& data);
	bool First(void);
	bool Next(void);
	bool GetCurrent(DataType& data);
	bool SetCurrent(const DataType& data);
	
private:

	Node* myCurrent;
	Node* myPrevious;
	Node* myHead;
};

#endif // List.h
