/*
 * Decompiled with CFR 0.152.
 */
package com.ethon.tools;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;
import java.awt.Color;

public class CounterUtil {
    public double getDistance2(double coord_X1, double coord_Y1, double coord_X2, double coord_Y2) {
        double x = coord_X1 - coord_X2;
        double y = coord_Y1 - coord_Y2;
        return x * x + y * y;
    }

    public double getPotential(double coord_Source_X, double coord_Source_Y, double weight, double coord_X, double coord_Y, double sigma) {
        double d = this.getDistance2(coord_Source_X, coord_Source_Y, coord_X, coord_Y);
        double exponent = d / Math.pow(sigma, 2.0);
        return weight * Math.pow(Math.E, -exponent);
    }

    public double getPotential(double coord_X, double coord_Y, double sigma) {
        double result = 0.0;
        DataBase db = DataBase.getInstance();
        DataPoint[] dataPoints = db.getPoints();
        int i = 0;
        int len = dataPoints.length;
        while (i < len) {
            DataPoint p = dataPoints[i];
            result += this.getPotential(p.getCoord_X(), p.getCoord_Y(), p.getWeight(), coord_X, coord_Y, sigma);
            ++i;
        }
        return result;
    }

    public static Color HLStoRGB(float H, float L, float S) {
        if (H > 1.0f || H < 0.0f) {
            return null;
        }
        if (S > 1.0f || S < 0.0f) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (L <= 0.0f) {
            b = 0.0f;
            g = 0.0f;
            r = 0.0f;
        } else if (L >= 1.0f) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            float hh = 6.0f * H % 6.0f;
            int c1 = (int)hh;
            float c2 = hh - (float)c1;
            float d = L <= 0.5f ? S * L : S * (1.0f - L);
            float w = L + d;
            float x = L - d;
            float y = w - (w - x) * c2;
            float z = x + (w - x) * c2;
            switch (c1) {
                case 0: {
                    r = w;
                    g = z;
                    b = x;
                    break;
                }
                case 1: {
                    r = y;
                    g = w;
                    b = x;
                    break;
                }
                case 2: {
                    r = x;
                    g = w;
                    b = z;
                    break;
                }
                case 3: {
                    r = x;
                    g = y;
                    b = w;
                    break;
                }
                case 4: {
                    r = z;
                    g = x;
                    b = w;
                    break;
                }
                case 5: {
                    r = w;
                    g = x;
                    b = y;
                }
            }
        }
        return new Color(r, g, b);
    }
}

