// Rational.h
//
// CSE2305 Tute 4 solution by Jon McCormack
//


#ifndef _RATIONAL_H_
#define _RATIONAL_H_

#include <string>
#include <iostream>

class Rational {
 public:
	typedef std::string string;
	typedef std::ostream ostream;

	Rational(int numerator = 0, int denominator = 1); // constructor for 2 ints
	Rational(const Rational& r);

	// accessor functions
	int getNumerator() const;
	int getDenominator() const;

	double asDouble() const; // returns (double)n/d
	string asString() const; // returns "n/d" as a string
	
	// setter functions
	void set(int numerator = 0, int denominator = 1);

	// operator overloads (internal to class)
	Rational& operator=(const Rational& rhs);
	Rational operator+(const Rational& rhs);
	Rational operator-(const Rational& rhs);
	bool operator<( const Rational& rhs ) const;
	bool operator<=( const Rational& rhs ) const;
	bool operator>( const Rational& rhs ) const;
	bool operator>=( const Rational& rhs ) const;
	bool operator==( const Rational& rhs ) const;
	bool operator!=( const Rational& rhs ) const;

	// printing
	ostream& print(ostream& s) const;
	friend ostream& operator<<(ostream& s, const Rational& r) {
		return s << r.n << '/' << r.d;
	}


 private:
	void reduce(void);		// reduce this Rational to its lowest terms
	static int gcd(int, int);	// utility method: greatest common divisor

	int n, d;

}; // Rational

#endif
