#include <stdio.h>
/* function  : search for a word in a dictionary given zero or more letters */
/*             in the word						*/	
/*             missing letter postions indicated by a ?              	*/ 
/* author    : K Marriott						*/
/* modified  : B Hurst							*/
/*             July 1993						*/
/* called by :								*/
/* calls     : initialize(file )					*/
/*             query (word sought)					*/
/*                                				 	*/


extern int initialize(FILE*);
extern char *query(char *);

main(int argc, char *argv[])
{
	FILE *dictfilepointer;
	char wordsought[11];
	char* wordfound;

	/* check there is a dictionary file name */
	if (argc != 2) {
		printf("You should give a dictionary name!\n");
		exit(1);
	}
	/* initialize internal data structure */
	dictfilepointer = fopen(argv[1], "r");
	printf("Initializing ... \n");
	if (!initialize( dictfilepointer))
		exit(1);

	/* process queries until EOF */
	printf("Please type queries, one per line\nQuery: ");
	while ( scanf("%10s",wordsought) != EOF)
		if (wordfound = query(wordsought))
			printf("Answer: %s\nQuery: ", wordfound);
		else
			printf("No matching word\nQuery: ");
	printf("\nThank you for your queries\n");
	exit(0);
}
