/*
 * height.c
 *
 * returns the height and normal at a given point
 * on the 2D landscape
 *
 * ** NOTE ** that this set of functions relies on an ordered formatting of the
 * vertex data and a square landscape. It will not work correctly for an
 * arbitrary model.
 *
 * Copyright 2007 Jon McCormack
 *
 */

#include "glm.h"
#include <stdio.h>
#include <math.h>

#define X	0
#define Y	1
#define Z	2

static int gridDim;				/* dimensions of grid, assumed to be square */
static GLfloat xmin, xmax, zmin, zmax;	/* corners of the island */

/*
 * getVertexComp
 *
 * utility function to return a vertex component
 */
static GLfloat getVertexComp(GLMmodel * pmodel, int vtx, int offset)
{
	return pmodel->vertices[vtx * 3 + offset];
}

/*
 * setHeights
 *
 * reads the model and sets variables required to process the heighs
 */
void setHeights(GLMmodel * pmodel)
{
	int i;

	printf("Model: %s (using material library \"%s\")\n", pmodel->pathname, pmodel->mtllibname);
	printf("Vertices = %d, Normals = %d, Facet normals= %d, Triangles = %d\n", pmodel->numvertices,
					pmodel->numnormals, pmodel->numfacetnorms, pmodel->numtriangles);
	
	gridDim = (int)sqrt(pmodel->numvertices);
	printf("Assuming grid size is %d x %d\n", gridDim, gridDim);
	
	xmin = getVertexComp(pmodel,1,X);
	zmax = getVertexComp(pmodel,1,Z);
	xmax = getVertexComp(pmodel,pmodel->numvertices,X);
	zmin = getVertexComp(pmodel,pmodel->numvertices,Z);

	printf("Model dimensions are: (%f,%f) -> (%f,%f)\n", xmin, zmin, xmax, zmax);

}

/*
 * getHeight
 *
 * returns the height of the landscape at a given point (x,z)
 * Note that this version doesn't do any interpolation across faces so there
 * is the possibility of instantaneous changes across edges.
 */
GLfloat getHeight(GLMmodel *pmodel, GLfloat xpos, GLfloat zpos, GLfloat normal[3])
{
	int xi, zi;
	int idx;

	normal[0] = normal[2] = 0.0f, normal[1] = 1.0;

	/* handle cases outside range of landscape */
	if (xpos < xmin || xpos > xmax) return 0.0;
	if (zpos < zmin || zpos > zmax) return 0.0;

	/* calculate array indicies */
	xi = (xpos - xmin)/(xmax - xmin) * (gridDim - 1) + 1;
	zi = gridDim - ((zpos - zmin)/(zmax - zmin) * (gridDim - 1));
	
	idx = zi * gridDim + xi;
	/* get normal */
	normal[0] = pmodel->normals[idx * 3];
	normal[1] = pmodel->normals[idx * 3 + 1];
	normal[2] = pmodel->normals[idx * 3 + 2];

	/* get height */
	return getVertexComp(pmodel, idx ,Y);
}

