/****************************************************************************

 File:    clampfloatparam.h
 Created: by Aidan Lane, February 13, 2004
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __CLAMPFLOATPARAM_H__
#define __CLAMPFLOATPARAM_H__


#include "doubleparam.h"

#define CLAMP_FLOAT_MIN 0.0
#define CLAMP_FLOAT_MAX 1.0
#define CLAMP_FLOAT_STEP 0.1
#define CLAMP_FLOAT_MAX_WIDGET_WIDTH 100


/*! \brief Represents a parameter of type <em>GLclampf</em>, used both by commmands and arrays.
 *
 * This class inherits DoubleParam and simply modifies the min, max and step
 * values and also the maximum widget width to its own likening.
 *
 * The floating-point value has been clamped to the <em>range of 0.0 to 1.0</em>.
 *
 * As an editor widget, it provides a SuperSpinBox, which is an extension of a
 * standard integer QSpinBox, but instead provides support of doubles and floats.
 */

class ClampFloatParam : public DoubleParam {

public:
	ClampFloatParam( const char* formalVarName, const char* defaultValue,
		const char* exactTypeName = "GLclampf" )
		: DoubleParam( formalVarName, defaultValue, exactTypeName,
			CLAMP_FLOAT_MIN, CLAMP_FLOAT_MAX, CLAMP_FLOAT_STEP,
			CLAMP_FLOAT_MAX_WIDGET_WIDTH ) {}
};


#endif	// __CLAMPFLOATPARAM_H__
