/****************************************************************************

 File:    intparam.h
 Created: by Aidan Lane, November 25, 2003
 Updated: by Aidan Lane, February 15, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __INTPARAM_H__
#define __INTPARAM_H__


#include <limits.h>

#include <qspinbox.h>
#include <qvalidator.h>

#include "cmdparam.h"

// Note: spin boxes will be created as wide AS REQUIRED BY THE CONTENTS
#define INTEGER_MIN INT_MIN
#define INTEGER_MAX INT_MAX
#define INTEGER_STEP 1
#define INTEGER_MAX_WIDGET_WIDTH 100


/*! \brief Represents a parameter of type <em>int</em>, used both by commmands and arrays.
 *
 * This class inherits CmdParam to provide a parameter that has a formal
 * variable name, a default value and an exact type name, among other fields.
 *
 * As an editor widget, it provides a simple integer QSpinBox.
 */

class IntParam : public CmdParam {

	Q_OBJECT	// make QT's signal/slot system work

public:
	IntParam( const char* formalVarName, const char* defaultValue,
		const char* exactTypeName = "GLint",
		int minValue = INTEGER_MIN, int maxValue = INTEGER_MAX,
		int stepValue = INTEGER_STEP,
		int maxWidgetWidth = INTEGER_MAX_WIDGET_WIDTH )
		: CmdParam( formalVarName, defaultValue, exactTypeName ),
			myMinValue(minValue), myMaxValue(maxValue), myStepValue(stepValue),
			myMaxWidgetWidth(maxWidgetWidth) {}

	// widgets
	virtual QWidget* createWidget( QWidget* parent, const char* name,
					const QObject *slotOwner, const char* member )
	{
		QSpinBox *w = new QSpinBox( myMinValue, myMaxValue, myStepValue,
		                            parent, name );
		connect( w, SIGNAL( valueChanged(int) ), slotOwner, member );
		return (QWidget*)w;
	}

	virtual void setWidgetValue( QWidget* widget, const QString& value ) {
		if ( widget != NULL )
			((QSpinBox*)widget)->setValue( value.toInt() );
	}

	virtual QString getWidgetValue( QWidget* widget ) {
		return (widget!=NULL) ? QString::number( ((QSpinBox*)widget)->value() ) : QString::null;
	}

	virtual int maxWidgetWidth() const {
		return INTEGER_MAX_WIDGET_WIDTH;
	}

private:
	int myMinValue;
	int myMaxValue;
	int myStepValue;
	int myMaxWidgetWidth;
};


#endif	// __INTPARAM_H__
