program cdbFile(input,output);

uses GPC;

const
   max_arg_num  = 10;   
   max_arg_len  = 256;
   max_str_len  = 256;
   max_num_char = 20000;
type
   set_of_char = set of char;
var
   inp    : text;
   out    : text;
   src    : text;
   exp    : text;
   i      : integer;
   offset : integer;
   return_code : integer;
   num_lines : integer;
   found     : boolean;
   dummy     : boolean;
   searching : boolean;
   line      : string[max_num_char];
   source    : string[max_num_char];
   word      : string[max_str_len];
   target    : string[max_str_len];
   action    : string[max_str_len];
   file_name : string[max_str_len];
   tail      : string[max_str_len];
   exp_file_name : string[max_str_len];

   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
   cmd_file       : string[max_str_len];
   
(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
(* -------------------------------------------------------------------------- *)

   procedure get_word(var word   : string;
                      var source : string;
                      var offset : integer;
                      var found  : boolean;
                          white_space : set_of_char;
                          delimeters  : set_of_char);
   var
      i         : integer;
      len       : integer;
      start     : integer;
      finish    : integer;
   begin
      found:=false;
      len:=length(source);
      if offset <= len then begin
         // skip leading white space
         start:=offset;
         for i:=offset to len do begin
            if not( source[i] in white_space ) then begin
               start:=i;
               break;
            end;
         end;
         // now get the word
         finish:=len;
         for i:=start to len do begin
            if not( source[i] in delimeters ) then finish:=i
                                              else break;
         end;
         setlength(word,finish-start+1);
         for i:=start to finish do begin
            word[i-start+1]:=source[i];
            found:=true;
         end;
         offset:=finish+2;
      end
      else word:='';
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure add_zero_at_end(var the_line : string);
   var
      i,j : integer;
      new_line : string[max_num_char];
   begin
      
      // to avoid a cadabra seg fault we replace the trailing ";" with " + 0;"
      
      trim(the_line);
      if length(the_line) > 0 then begin
         if the_line[1] <> '@' then begin
            j:=0;
            for i:=1 to length(the_line) do begin // scan just in case more than one ";"
               if the_line[i] = ';' then begin
                  j:=i;
                  break;
               end;
            end;
            if j > 0 then the_line[j]:=' ';
            new_line:=the_line + ' + 0;';
            the_line:=new_line;
         end;
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      if cmd_line_num > 0 then cmd_file:=cmd_line_arg[1]
                          else cmd_file:="/tmp/tmp.del";
                             
   end;
   
(* -------------------------------------------------------------------------- *)

begin
   
   initialize;
   
   if cmd_line_num = 2 then begin // LCB : a bit sloppy! *any* 2nd argumnet will trigger this
      
      // list all the names of the expressions in the library
      // usage : cdbfile metric.lib names
      
      file_name:=cmd_line_arg[1];
      
      reset(src,file_name);
   
      while (not eof(src)) do begin
      
         readln(src,line);
      
         offset:=1;
         get_word(word,line,offset,found,[' '],[':']);
         if found then begin
            writeln(word);
         end;
      
      end;
   
      close(src);
   
   end
   else begin
      
      // this section run only by a call from within cadabra
   
      reset(inp,cmd_file);
   
      if not eof(inp) then begin
      
         readln(inp,source);
         strip_quotes(source);
      
         offset:=1;
         get_word(action,source,offset,found,[' '],[' ']);
         get_word(file_name,source,offset,found,[' '],[' ']);
      
         tail:="";
         for i:=offset to length(source) do tail:=tail + source[i];
      
         trim(action);
         trim(file_name);
         trim(tail);
      
         if action = "open" then begin
         
            rewrite(out,file_name);
            close(out);
         
            writeln("DoneOpen;");
         
         end;
      
         if action = "delete" then begin
         
            return_code:=Execute('rm -f '+file_name);
         
            writeln("DoneDelete;");
         
         end;
      
         if action = "export" then begin
      
            append(out,file_name);
      
            exp_file_name:=tail;
            reset(exp,exp_file_name);
      
            while not eof(exp) do begin
               readln(exp,line);
               add_zero_at_end(line); // this is a cadabra bug-fix
               if length(line) > 0 then begin
                  if line[1] <> "@" then writeln(out,line);
               end;
            end;
         
            // separate experssions with a blank line
         
            writeln(out);
      
            close(exp);
            close(out);
         
            return_code:=Execute('rm -f '+exp_file_name);
         
            writeln("DoneExport;");
         
         end;
      
         if action = "import" then begin
         
            reset(src,file_name);
         
            target:=tail;

            num_lines:=0;
            found:=false;
         
            if not eof(src) then searching:=true
                            else searching:=false;
         
            // count lines in src until we find the target
         
            while (not eof(src)) and (searching) do begin
            
               readln(src,line);
               num_lines:=num_lines+1;
            
               offset:=1;
               get_word(word,line,offset,dummy,[' '],[':']);
               if word = target then begin
                  found:=true;
                  searching:=false;
               end;
            
            end;
         
            close(src);
         
            if found then begin
            
               // skip lines before the target expression
            
               reset(src,file_name);
               for i:=1 to num_lines-1 do readln(src);
            
               // next line in src is start of our target expression
               // read that line and drop the expression name, write out the remainder
            
               readln(src,line);
               offset:=1;
               get_word(word,line,offset,dummy,[' '],[':']);
               for i:=offset+1 to length(line) do write(line[i]); // offset+1 to skip the "=" in ":="
               writeln;
            
               // read & write remaining lines in expression until first blank line or eof
            
               searching:=true;
            
               while (not eof(src)) and (searching) do begin
               
                  readln(src,line);
               
                  if length(line) > 0 then writeln(line)
                                      else searching:=false;
                                      
               end;
            
               close(src);
            
            end
            else writeln("NotFound;");
            
         end;
      
         if action = "comment" then begin
      
            append(out,file_name);
      
            writeln(out,"# "+tail);
      
            // add a blank line for pure decoration
         
            writeln(out);
      
            close(out);
         
            writeln("DoneComment;");
         
         end;
      
      end;

      close(inp);
      
   end;
   
   // return_code:=Execute('rm -f '+cmd_file);
      
end.

   
   
         
         