program cdbMerge(input,output);
const
   max_arg_num = 10;   
   max_arg_len = 128;
   max_num_char = 20000;
   max_found_word = 100;
type
   set_of_char      = set of char;
   mode_type        = (mode_latex,mode_verbatim,mode_comment,mode_none);
   write_type       = (write_char,write_line);
var
   i              : integer;
   
   num_char       : integer;
   input_stream   : string[max_num_char];
   
   save_input     : boolean;
   syntax_error   : boolean;
   prev_line_empty : boolean;
   
   this_line      : string[max_num_char];
   prev_line      : string[max_num_char];
   next_line      : string[max_num_char];
   command        : string[max_num_char];
   remainder      : string[max_num_char];
   latex_eqtn     : string[max_num_char];
   eqtn_num       : string[255];
   err_text       : string[255];
   the_at_pos     : integer;
   the_gt_pos     : integer;
   the_cr_pos     : integer;
   
   i_max          : integer;
   src            : text;
   eqn            : text;
   tex            : text;
   eqtn_table     : array[1..500] of string[max_num_char];
   num_eqtn_lines : integer;
   latex          : string[max_num_char];
   comment        : string[max_num_char];
   
   current_mode   : mode_type;
   last_write     : write_type;
   
   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
   cdb_file       : string[255];
   xcd_file       : string[255];
   eqn_file       : string[255];
   tex_file       : string[255];
   tmp_file       : string[255];

(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
{$include "cdb-parse.p"} 
(* -------------------------------------------------------------------------- *)

   procedure start_scan;
   begin
      
      the_at_pos:=0;
      the_gt_pos:=0;
      the_cr_pos:=0;
   
      first_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
   
      if (not did_read) and (not did_readln) then begin
         input_stream:=chr(13);
      end
      else begin
         if did_read then input_stream:=this_char
                     else input_stream:=chr(13);
      end;
      
      num_char:=1;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure next_scan;
   begin
      
      scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if did_read then begin
         if save_input then input_stream:=input_stream+this_char;
         num_char:=length(input_stream);
      end;
      
      if did_readln then begin
         if save_input then input_stream:=input_stream+chr(13);
         num_char:=length(input_stream);
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure final_scan;
   begin
      
      last_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      num_char:=1;
      input_stream:=chr(13);
            
   end;
   
(* -------------------------------------------------------------------------- *)

   function at_boln(the_word:string):boolean;
   var
      the_length : integer;
   begin
      
      // at_boln : "at begining of line"
      
      // did the current line begin with the_word?
      // yes -- if the character that preceedes the_word is chr(13)
      // but note if the_word also ends the line then the input_stream will contain a trailing chr(13)
      
      the_length:=length(the_word);
      
      if input_stream[num_char] = chr(13) then begin // the_word terminates the current line
         
         if num_char <= the_length + 1 then begin
            at_boln:=true;
         end
         else begin
            if input_stream[num_char-the_length-1] = chr(13) then at_boln:=true
                                                             else at_boln:=false;
         end
                                                             
      end
      else begin // there is more (unread) text on the current line
         
         if num_char <= the_length then begin
            at_boln:=true;
         end
         else begin
            if input_stream[num_char-the_length] = chr(13) then at_boln:=true
                                                           else at_boln:=false;
         end
                                                             
      end;
               
   end;

(* -------------------------------------------------------------------------- *)

   function empty(var this_string : string) : boolean;
   var
      i : integer;
      is_empty : boolean;
   begin
      
      is_empty:=true;
      
      if length(this_string) <> 0 then begin
         for i:=1 to length(this_string) do begin
            if not (this_string[i] in [' ','%',chr(13)]) then is_empty:=false;
         end;
      end;
      
      empty:=is_empty;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure filter(var this_line : string);
   var
      i : integer;
      new_line : string[max_num_char];
   begin
      
      if current_mode <> mode_latex then begin
         
         new_line:='';
      
         // a few basic characters to escape, maybe more?
      
         for i:=1 to length(this_line) do begin
            case this_line[i] of
               '<' : new_line:=new_line + '\cdblt{}' ;
               '>' : new_line:=new_line + '\cdbgt{}' ;
               '_' : new_line:=new_line + '\cdbunder{}' ;
               '~' : new_line:=new_line + '\cdbtilde{}' ;
               '%' : new_line:=new_line + '\cdbpcent{}' ;
               otherwise new_line:=new_line + this_line[i];
            end;
         end;
      
         trim(new_line);
      
         this_line:=new_line;
      
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure filter_err(var this_line : string);
   var
      i : integer;
      new_line : string[max_num_char];
   begin
      
      new_line:='';
      
      // a few basic characters to escape, maybe more?
      
      for i:=1 to length(this_line) do begin
         case this_line[i] of
            '<' : new_line:=new_line + '\cdblt{}' ;
            '>' : new_line:=new_line + '\cdbgt{}' ;
            '_' : new_line:=new_line + '\cdbunder{}' ;
            '~' : new_line:=new_line + '\cdbtilde{}' ;
            '%' : new_line:=new_line + '\cdbpcent{}' ;
            '\' : new_line:=new_line + '\cdbslash{}' ;
            '#' : new_line:=new_line + '\cdbhash{}'  ;
            otherwise new_line:=new_line + this_line[i];
         end;
      end;
      
      trim(new_line);
      
      this_line:=new_line;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure skip_past_discard(target : string);
   begin
      
      save_input:=false;
      
      while (not eof(src)) and (not syntax_error) do begin
         
         next_scan;
         
         if found_word then begin
         
            if length(the_word) = length(target) then begin
               
               if the_word = target then break;
               
            end;
            
            if length(the_word) = 5 then begin
            
               if the_word = 'ERROR' then begin
                  
                  syntax_error:=true;
               
               end;
         
            end;
                     
            start_scan;
               
         end;
         
      end;
      
      save_input:=true;
               
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure skip_past_retain(    target   : string;
                              var the_text : string);
   var
      i : integer;
      tmp_text : string[max_num_char];
   begin
      
      save_input:=true;
      
      the_text:='';
      tmp_text:='';
      
      while (not eof(src)) and (not syntax_error) do begin
         
         next_scan;
         
         if this_char = "%" then begin

            trim(tmp_text);
            writeln(eqn,tmp_text,'%');
            tmp_text:='';

            start_scan;
               
         end
         else
            tmp_text:=tmp_text + this_char;
            
         if found_word then begin
         
            if length(the_word) = length(target) then begin
               
               if the_word = target then begin
                  for i:=1 to length(tmp_text)-length(target)-1 do the_text:=the_text + tmp_text[i];
                  trim(the_text);
                  start_scan;
                  break;
               end;
               
            end;
            
            if length(the_word) = 5 then begin
            
               if the_word = 'ERROR' then begin
                  
                  the_text:='';
                  syntax_error:=true;
               
               end;
         
            end;
         
            start_scan;
               
         end;
         
      end;
               
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure read_cdb_output;
   var
      searching : boolean;
      this_line : string[max_num_char];
   begin
      
      // we get here after reading a ";" in the cdb file
      // this cdb line will have some output connected with it
      // this will normally be the Cadabra output for that line
      // but Cadabra may also generate messages and errors
      // messages will be merged with the output for the equation
      // but errors generate no output other than error message itself
      // 
      // thus for this ";" word in the cdb file we will
      //    1) read just one line if it is an \cdberror line
      //    2) read lines until eof or we hit \endeqtn or \endmessage
      //
      //    the lines that we read in this step will be the lines
      //    that we assoicate with this ";" word in the cdb file
      //    
      // if we allow the error message to be associated with the
      // the output text then we will be pulling forward output from
      // later in the cdb file. the printed output will appear early
            
      searching:=true;
      
      while ( not eof(eqn) ) and ( searching ) do begin
         readln(eqn,this_line);
         trim(this_line);
         if match_word(this_line,'\cdberror') then begin
            num_eqtn_lines:=num_eqtn_lines+1;
            eqtn_table[num_eqtn_lines]:=this_line;
            searching:=false;
         end
         else begin
            if    (match_word(this_line,'\endeqtn')) 
               or (match_word(this_line,'\endprint')) then begin
               searching:=false;
            end
            else begin
               num_eqtn_lines:=num_eqtn_lines+1;
               eqtn_table[num_eqtn_lines]:=this_line;
            end;
         end;
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure decorate_eqns;
   var
      j : integer;
      decorate_on : boolean;
      new_line    : string[max_num_char];
      this_line   : string[max_num_char];
   begin
      
      // 1st pass : decorate cdbeqtn
      
      // read from tmp, write to eqn
      
      reset(src,tmp_file);
      rewrite(eqn,eqn_file);
      
      decorate_on:=false;
      
      while not eof(src) do begin
         
         readln(src,this_line);
         
         if match_word(this_line,'\cdbeqtn') then decorate_on:=true;
         if match_word(this_line,'\endeqtn') then decorate_on:=false;
      
         if decorate_on then begin
            
            // introduce \left and \right to decorate the output
      
            new_line:='';
            
            for j:=1 to length(this_line) do begin
               case this_line[j] of
                  '(' : new_line:=new_line + '\left(';
                  ')' : new_line:=new_line + '\right)';
                  otherwise new_line:=new_line + this_line[j];
               end;
            end;
            
            this_line:=new_line;
         
         end;
         
         writeln(eqn,this_line);
         
      end;
      
      close(src);
      close(eqn);

      // 2nd pass : decorate cdbprint
      
      // read from eqn, write to tmp
      
      reset(src,eqn_file);
      rewrite(eqn,tmp_file);
      
      decorate_on:=false;
      
      while not eof(src) do begin
         
         readln(src,this_line);
         
         if match_word(this_line,'\cdbprint') then decorate_on:=true;
         if match_word(this_line,'\endprint') then decorate_on:=false;
      
         if decorate_on then begin
            
            // introduce \left and \right to decorate the output
      
            new_line:='';
            
            for j:=1 to length(this_line) do begin
               case this_line[j] of
                  '(' : new_line:=new_line + '\left(';
                  ')' : new_line:=new_line + '\right)';
                  otherwise new_line:=new_line + this_line[j];
               end;
            end;
            
            this_line:=new_line;
         
         end;
         
         writeln(eqn,this_line);
         
      end;
      
      close(src);
      close(eqn);

      // 3rd pass : copy from tmp to eqtn
      
      // read from tmp, write to eqn
      
      reset(src,tmp_file);
      rewrite(eqn,eqn_file);
      
      while not eof(src) do begin
         
         readln(src,this_line);
         writeln(eqn,this_line);
         
      end;
      
      close(src);
      close(eqn);

   end;
   
(* -------------------------------------------------------------------------- *)

   procedure bail_out;
   begin
      writeln(' bail out');
      halt(1);
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure write_eqn_file;
      
      procedure process_word;
      begin
         
         if the_word = ':=' then begin       // start of cadabra-LaTeX output
            eqtn_num:='';
            for i:=max(the_cr_pos,the_gt_pos)+1 to num_char-2 do begin
               eqtn_num:=eqtn_num + input_stream[i];
            end;
            trim(eqtn_num);
            writeln(eqn,'\cdbeqtn{',eqtn_num,'}%');
            write(eqn,'{');
            skip_past_discard('<plain>');
            skip_past_discard('</plain>');
            skip_past_retain(';',latex_eqtn);
            if not syntax_error then begin
               writeln(eqn,latex_eqtn,'}%');
               writeln(eqn,'\endeqtn');
            end
            else begin
               writeln(eqn,'}%');
               writeln(eqn,'\endeqtn');
               readln(src,err_text);
               filter_err(err_text);
               writeln(eqn,'\cdberror{',err_text,'}');
            end;
         end;
         
         if the_word = '<progress>' then begin
            readln(src,this_line);
            if this_line = 'prin' then begin       // start of cadabra-LaTeX @print output
               writeln(eqn,'\cdbprint%');
               write(eqn,'{');
               skip_past_discard("</progress>");
               skip_past_retain("?",latex_eqtn);
               if not syntax_error then begin
                  writeln(eqn,latex_eqtn,'}%');
                  writeln(eqn,'\endprint');
               end
               else begin
                  writeln(eqn,'}%');
                  writeln(eqn,'\endprint');
                  readln(src,err_text);
                  filter_err(err_text);
                  writeln(eqn,'\cdberror{',err_text,'}');
               end;
            end;
         end;  
      
         if the_word = ': ' then begin       // cadabra's warning messages, eg. "not applicable"
            command:='@';
            for i:=the_at_pos+1 to num_char-2 do command:=command + input_stream[i];
            filter(command);
            readln(src,this_line);
            remainder:=this_line;
            writeln(eqn,'\cdbmessage{',command,'}{',remainder,'}');
         end;
      
         if the_word = 'ERROR' then begin
         
            readln(src,err_text);
            filter_err(err_text);
            writeln(eqn,'\cdberror{',err_text,'}');
         
            syntax_error:=true;
         
         end;
            
      end;
         
   begin
   
      reset(src,xcd_file);
      rewrite(eqn,tmp_file);
      
      keyword[ 1]:=';'; 
      keyword[ 2]:='?'; 
      keyword[ 3]:=':='; 
      keyword[ 4]:=': '; 
      keyword[ 5]:='Cadabra';    
      keyword[ 6]:='Opening';    
      keyword[ 7]:='Closing';    
      keyword[ 8]:='ERROR';
      keyword[ 9]:='<plain>';
      keyword[10]:='</plain>';
      keyword[11]:='<progress>';
      keyword[12]:='</progress>';
      keyword[13]:='<property>';
      keyword[14]:='</property>';
      keyword[15]:='<algorithm>';
      keyword[16]:='</algorithm>';
   
      num_keyword:=17;   

      new_keyword_tbl(num_keyword);
   
      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)
   
      start_scan;
      
      save_input:=true;

      while (not eof(src)) do begin
         
         syntax_error:=false;
         
         if num_char >= max_num_char then bail_out;
      
         if input_stream[num_char] = chr(13) then begin
            the_cr_pos:=num_char;
         end;
         
         if input_stream[num_char] = '>' then begin
            the_gt_pos:=num_char;
         end;
      
         if input_stream[num_char] = '@' then begin
            the_at_pos:=num_char;
         end;
         
         if found_word then begin
         
            process_word;
            start_scan;
         
         end
         else next_scan;
         
      end;
      
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if found_word then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if found_word then process_word;
   
      close(src);
      close(eqn);
      
      decorate_eqns;
   
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure write_tex_file;

      procedure process_word;
      begin
   
         // flush out all text excluding the_word and possibly a trailing chr(13)
         // the_word will be written out in the following if-then-else block
      
         if (not empty(input_stream)) then begin
            i_max:=length(input_stream);
            if input_stream[i_max] = chr(13) then i_max:=max(0,i_max-1);
            if (the_word = ";")  then i_max:=max(0,i_max-length(the_word));
            if (the_word = "#")  then i_max:=max(0,i_max-length(the_word));
            if (the_word = "%%") then i_max:=max(0,i_max-length(the_word));
            if (the_word = "%<") then i_max:=max(0,i_max-length(the_word));
            if (the_word = "%>") then i_max:=max(0,i_max-length(the_word));
            if (the_word = "%!") then i_max:=max(0,i_max-length(the_word));
            for i:=1 to i_max do begin
               if input_stream[i] <> chr(13) then begin
                  write(tex,input_stream[i]);
                  last_write:=write_char;
               end
               else begin
                  writeln(tex);
                  last_write:=write_line;
               end;
            end;
         end;

         if the_word = ";" then begin
            
            // A ";" signals to Cadabra that the output for this expression should be displayed.
            // Here we capture that output for later processing (by LaTeX and friends)
            // However, Cadabra allows one exception. When the ";" is followed by a quoted
            // string then the output is redirected to a file, the name being set by the
            // contents of the string. In this case there will be no output to capture so
            // we dont call "read_cdb_output".
            // 
            // But this logic fails for the simple and valid code
            //    
            //    @(abc); @(def); @(pqr);
            //    
            // One way to avoid this problem is demand that all lines that can produce
            // output should contain just one ";". Its not ideal but it works.
            
            if input_stream[num_char] = chr(13) then begin // are we at the end of the line?
            
               read_cdb_output;
         
               writeln(tex,';');
               last_write:=write_line;
            
            end
            else begin // we're not at the end of line, so don't read_cdb_output here
            
               write(tex,';');
               last_write:=write_char;
            
            end;
   
         end;
      
         if the_word = '#' then begin
         
            if at_boln(the_word) then begin
         
               case current_mode of
                  mode_comment  : ;
                  mode_latex    : ;
                  mode_verbatim : writeln(tex,'\end{cdbverbatim}');
                  otherwise ;
               end;

               if current_mode <> mode_comment then begin
                  writeln(tex,'\begin{cdbcomment}');
                  current_mode:=mode_comment;
               end;
      
               if not (input_stream[num_char] = chr(13)) then readln(src,comment)
                                                         else comment:='';
               writeln(tex,'#',comment);// don't trim because don't want to change the users pretty layout
      
               // comment block terminated by an empty line or any line not starting with #
      
               if src^ <> "#" then begin
                  writeln(tex,'\end{cdbcomment}');
                  writeln(tex,'\begin{cdbverbatim}');
                  current_mode:=mode_verbatim;
               end;
         
               last_write:=write_line;
         
            end
            else begin
            
               write(tex,'#');
               last_write:=write_char;
            
            end;
         
         end;

         if the_word = "%%" then begin
         
            if at_boln(the_word) then begin
            
               case current_mode of
                  mode_latex    : ;
                  mode_comment  : writeln(tex,'\end{cdbcomment}');
                  mode_verbatim : writeln(tex,'\end{cdbverbatim}');
                  otherwise ;
               end;
   
               if current_mode <> mode_latex then begin
                  current_mode:=mode_latex;
               end;
         
               if not (input_stream[num_char] = chr(13)) then readln(src,latex)
                                                         else latex:='';
               trim(latex);
               writeln(tex,latex);
         
               // latex block terminated by an empty line or any line not starting with %
         
               if src^ <> "%" then begin
                  writeln(tex,'\begin{cdbverbatim}');
                  current_mode:=mode_verbatim;
               end;
         
               last_write:=write_line;
         
            end
            else begin // should we exclude this case ? yes, I think
            
               write(tex,'%%');
               last_write:=write_char;
            
            end;
         
         end;

         if the_word = "%!" then begin
         
            if at_boln(the_word) then begin
   
               case current_mode of
                  mode_latex    : ;
                  mode_comment  : writeln(tex,'\end{cdbcomment}');
                  mode_verbatim : writeln(tex,'\end{cdbverbatim}');
                  otherwise ;
               end;
   
               for i:=1 to num_eqtn_lines do writeln(tex,eqtn_table[i]);
               num_eqtn_lines:=0;
         
               writeln(tex,'\begin{cdbverbatim}');
               last_write:=write_line;
               current_mode:=mode_verbatim;
            
            end
            else begin // should we exclude this case ? yes, I think
            
               write(tex,'%!');
               last_write:=write_char;
            
            end;
   
         end;
            
         if the_word = "%<" then begin
            // start of cell, ignored, just for use by Texmate as a folding-marker
         end;

         if the_word = "%>" then begin
            // end of the cell, so switch to verbatim mode
            case current_mode of
               mode_latex    : ;
               mode_comment  : writeln(tex,'\end{cdbcomment}');
               mode_verbatim : writeln(tex,'\end{cdbverbatim}');
               otherwise ;
            end;
            writeln(tex,'\begin{cdbverbatim}');
            last_write:=write_line;
            current_mode:=mode_verbatim;
         end;
      
         // done with the input, so let's clear the input stream
      
         input_stream:='';
         num_char:=0;

      end;
   
   begin

      reset(src,cdb_file);
      reset(eqn,eqn_file);
      rewrite(tex,tex_file);
   
      writeln(tex,'\documentclass{cadabra}');
      writeln(tex,'\begin{document}');
         
      keyword[1]:=';'; 
      keyword[2]:='#'; 
      keyword[3]:='%%'; 
      keyword[4]:='%!';    
      keyword[5]:='%<';    
      keyword[6]:='%>';    

      num_keyword:=6;   

      new_keyword_tbl(num_keyword);

      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)

      num_eqtn_lines:=0;
      
      current_mode:=mode_none;
      
      if not eof(src) then begin
         while eoln(src) do begin
            readln(src);
         end;
         if not eof(src) then begin
            case src^ of
               '%' : current_mode:=mode_latex;
               '#' : current_mode:=mode_comment;
               otherwise current_mode:=mode_verbatim;
            end;
         end;
      end;
      
      case current_mode of
         mode_latex    : ;
         mode_comment  : writeln(tex,'\begin{cdbcomment}');
         mode_verbatim : writeln(tex,'\begin{cdbverbatim}');
         otherwise ;
      end;
      
      last_write:=write_line;

      start_scan;

      while not eof(src) do begin
         
         if num_char >= max_num_char then bail_out;
      
         if input_stream[num_char] = chr(13) then begin
            the_cr_pos:=num_char;
         end;
         
         if found_word then begin
            
            process_word;
            start_scan;
            
         end
         else next_scan;
   
      end;
               
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if found_word then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if found_word then process_word;
   
      // flush out any remaining equations and messages

      if length(input_stream) > 0 then begin
         
         for i:=1 to length(input_stream) do begin
            if input_stream[i] <> chr(13) then begin
               write(tex,input_stream[i]);
               last_write:=write_char;
            end
            else begin
               writeln(tex);
               last_write:=write_line;
            end;
         end;

         if last_write <> write_line then begin
            writeln(tex);
            last_write:=write_line;
         end;
      
      end
      else begin
         
         if last_write <> write_line then begin
            writeln(tex);
            last_write:=write_line;
         end;
      
      end;
            
      case current_mode of
         mode_latex    : ;
         mode_comment  : writeln(tex,'\end{cdbcomment}');
         mode_verbatim : writeln(tex,'\end{cdbverbatim}');
         otherwise ;
      end;
          
      for i:=1 to num_eqtn_lines do writeln(tex,eqtn_table[i]);
      
      writeln(tex,'\end{document}');
   
      close(src);
      close(eqn);
      close(tex);
      
      (* --- clean up tex file by removing surplus empty lines --------------- *)
      
      (* ---------------------------------------------------------------------
            delete all empty lines following \begin{cdbcomment} etc. and
            delete all empty lines preceeding \end{cdbcomment} etc.
         --------------------------------------------------------------------- *)
      
      reset(src,tex_file);
      rewrite(tex,tmp_file);
      
      prev_line_empty:=false;
   
      while not eof(src) do begin
         
         readln(src,this_line);
         
         if not empty(this_line) then begin
            
            if (prev_line_empty) then begin
               if (   (prev_line = '\begin{cdbcomment}')
                   or (prev_line = '\begin{cdbverbatim}') )
               then
               else begin
                  if not (    (this_line = '\end{cdbcomment}')
                           or (this_line = '\end{cdbverbatim}') ) then begin
                     writeln(tex);
                     prev_line_empty:=false;
                  end;
               end;
            end;
            
            writeln(tex,this_line);
            prev_line:=this_line;
            prev_line_empty:=false;
            
         end
         else begin
            
            prev_line_empty:=true;
            
         end;
         
      end;
      
      close(src);
      close(tex);
      
      (* ---------------------------------------------------------------------
            delete pairs of lines like 
               \begin{cdbcomment}
               \end{cdbcomment}
         --------------------------------------------------------------------- *)
      
      reset(src,tmp_file);
      rewrite(tex,tex_file);
      
      while not eof(src) do begin
         
         readln(src,this_line);
         
         if this_line = '\begin{cdbcomment}' then begin
            if not eof(src) then readln(src,next_line)
                            else next_line:='\end{cdbcomment}';
            if next_line <> '\end{cdbcomment}' then begin
               writeln(tex,this_line);
               writeln(tex,next_line);
            end;
         end
         else begin
      
            if this_line = '\begin{cdbverbatim}' then begin
               if not eof(src) then readln(src,next_line)
                               else next_line:='\end{cdbverbatim}';
               if next_line <> '\end{cdbverbatim}' then begin
                  writeln(tex,this_line);
                  writeln(tex,next_line);
               end;
            end
            else begin
               writeln(tex,this_line);
            end;
            
         end;
            
      end;
      
      close(src);
      close(tex);
      
   end;

(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      cdb_file:=cmd_line_arg[1]+".cdb";
      xcd_file:=cmd_line_arg[1]+".xcd";
      eqn_file:=cmd_line_arg[1]+".eqn";
      tex_file:=cmd_line_arg[1]+".tex";
      tmp_file:=cmd_line_arg[1]+".tmp";
      
   end;
   
begin
   
   initialize;
   
   write_eqn_file;
   write_tex_file;
   
end.
