program cdbTags(input,output);

uses GPC;

const
   max_arg_num = 10;   
   max_arg_len = 128;
   max_tag_len  = 32;
   max_file_len = 128;
   max_num_char = 20000;
   max_num_save = 200;
   max_found_word = 100;
type
   set_of_char      = set of char;
   save_tags_data   = record
                         num_tag  : integer;
                         tag      : array[1..max_num_save] of string[max_tag_len];
                         tag_file : array[1..max_num_save] of string[max_file_len];
                         tag_char : array[1..max_num_save] of integer;
                         tag_line : array[1..max_num_save] of integer;
                      end;
var
   i,j            : integer;
   in_tex_comment : boolean;
   
   num_line       : integer;
   num_char       : integer;
   the_tag_key    : integer;
   the_tag_line   : integer;
   the_tag_char   : integer;
   the_tag_word   : string[max_tag_len];
   the_tag_file   : string[max_file_len];
   
   target         : string[max_tag_len];
   
   src_tags       : save_tags_data;
   tex_tags       : save_tags_data;
   
   tex            : text;
   src            : text;
   out            : text;
   
   file_name_src  : string[255];
   file_name_tex  : string[255];
   file_name_out  : string[255];
   
   the_tex_line   : string[max_num_char];
   the_src_line   : string[max_num_char];
   
   no_tag         : array[1..max_num_save] of boolean;
   
   char_beg       : array[1..max_num_save] of integer;
   line_beg       : array[1..max_num_save] of integer;
   
   char_end       : array[1..max_num_save] of integer;
   line_end       : array[1..max_num_save] of integer;
   
   num_skip_lines : array[1..max_num_save] of integer;
   
   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
{$include "cdb-parse.p"} 
(* -------------------------------------------------------------------------- *)

   procedure start_scan;
   begin
      
      first_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
   
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;

   end;

(* -------------------------------------------------------------------------- *)

   procedure next_scan;
   begin
      
      scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_key:=this_word_key;
         the_tag_char:=num_char;
         the_tag_line:=num_line;
      end;
            
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;

   end;
   
(* -------------------------------------------------------------------------- *)

   procedure final_scan;
   begin
      
      last_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_line:=num_line;
         the_tag_char:=num_char;
      end;
            
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure read_word(var word : string;
                           beg_word_chars : set_of_char;
                           end_word_chars : set_of_char);
   var
      dummy     : char;
      the_char  : char;
   begin
      
      while not (src^ in beg_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,dummy);
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
      read(src,dummy);
      num_char:=num_char+1;
      
      word:='';
      
      while not (src^ in end_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,the_char);
               word:=word+the_char;
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
   end;
      
(* -------------------------------------------------------------------------- *)

   procedure find_tags_src(var target : string;
                           var file_name : string);
   var
      i : integer;
      
      procedure process_word;
      begin
         read_word(the_tag_word,['{'],['}']);
         if the_tag_word = target then with src_tags do begin
            num_tag:=num_tag+1;
            tag[num_tag]:=keyword[the_tag_key]+'{'+the_tag_word+'}';
            tag_file[num_tag]:='';
            tag_char[num_tag]:=the_tag_char+length(the_tag_word)+2;
            tag_line[num_tag]:=the_tag_line;
         end;
      end;
   
   begin
      
      keyword[1]:='\Btag'; 
      keyword[2]:='\Etag'; 

      num_keyword:=2;   

      new_keyword_tbl(num_keyword);

      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)
   
      reset(src,file_name);
   
      num_char:=0;
      num_line:=1;
      the_tag_line:=0;
      the_tag_char:=0;
      in_tex_comment:=false;
      
      src_tags.num_tag:=0;
   
      start_scan;

      while not eof(src) do begin
      
         if (found_word) and (not in_tex_comment) then begin
         
            process_word;
            start_scan;
         
         end
         else next_scan;
      
      end;

      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      close(src);
   
      // with src_tags do begin
      //    for i:=1 to num_tag do begin
      //       writeln(i:3,' ',tag_line[i]:3,' ',tag_char[i]:3,' !',tag[i],'!');
      //    end;
      // end;
   
   end;

(* -------------------------------------------------------------------------- *)

   procedure find_tags_tex(var file_name : string);
                           
   var
      i : integer;
      
      procedure process_word;
      begin
         read_word(the_tag_word,['{'],['}']);
         read_word(the_tag_file,['{'],['}']);
         with tex_tags do begin
            num_tag:=num_tag+1;
            tag[num_tag]:=keyword[the_tag_key]+'{'+the_tag_word+'}';
            tag_file[num_tag]:=the_tag_file;
            tag_char[num_tag]:=the_tag_char+length(the_tag_word)+2;
            tag_line[num_tag]:=the_tag_line;
         end;
      end;
   
   begin
      
      keyword[1]:='\Btag'; 
      keyword[2]:='\Etag'; 

      num_keyword:=2;   

      new_keyword_tbl(num_keyword);

      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)
   
      reset(src,file_name);
   
      num_char:=0;
      num_line:=1;
      the_tag_line:=0;
      the_tag_char:=0;
      in_tex_comment:=false;
      
      tex_tags.num_tag:=0;
   
      start_scan;

      while not eof(src) do begin
      
         if (found_word) and (not in_tex_comment) then begin
         
            process_word;
            start_scan;
         
         end
         else next_scan;
      
      end;

      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      close(src);
   
      // with tex_tags do begin
      //    for i:=1 to num_tag do begin
      //       writeln(i:3,' ',tag_line[i]:3,' ',tag_char[i]:3,' !',tag[i],'!',tag_file[i],'!');
      //    end;
      // end;
   
   end;

(* -------------------------------------------------------------------------- *)

   procedure replace_tag(var the_line : string);
   var
      i : integer;
      word : string[10];
   begin
      
      for i:=1 to length(the_line)-5 do begin
         word:= the_line[i]
               +the_line[i+1]
               +the_line[i+2]
               +the_line[i+3]
               +the_line[i+4]
               +the_line[i+5];
         if word = '\Btag{' then begin
            the_line[i+1]:='W';
            break;
         end;
      end;
      
   end;

(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      file_name_tex:=cmd_line_arg[1]+".texp";
      file_name_src:=cmd_line_arg[1]+".src";
      file_name_out:=cmd_line_arg[1]+".tex";
      
   end;
   
begin
   
   initialize;
   
   // read the tags in the tex file. 
   // the text for these tags will be replaced by text drawn from the src file
      
   find_tags_tex(file_name_tex);
   
   // compute beg/end pairs for reading text from the tex and src files
   
   num_skip_lines[1]:=max(0,tex_tags.tag_line[1] - 1);
   
   for i:=2 to tex_tags.num_tag do with tex_tags do begin
      num_skip_lines[i]:=max(0,tag_line[i] - tag_line[i-1] - 1);
   end;
      
   for i:=1 to tex_tags.num_tag do with tex_tags do begin
      
      target:='';
      for j:=7 to length(tag[i])-1 do target:=target + tag[i,j];
         
      file_name_src:=tag_file[i];
      
      if FileExists(file_name_src) then begin
      
         find_tags_src(target,file_name_src);
      
         j:=src_tags.num_tag;
      
         if j > 0 then begin
      
            char_beg[i]:=src_tags.tag_char[j-1];
            line_beg[i]:=src_tags.tag_line[j-1];
      
            char_end[i]:=src_tags.tag_char[j];
            line_end[i]:=src_tags.tag_line[j];
      
            no_tag[i]:=false;
         
         end
         else begin
         
            char_beg[i]:=0;
            line_beg[i]:=0;
      
            char_end[i]:=0;
            line_end[i]:=0;
         
            no_tag[i]:=true;

         end;
      
      end
      else begin

         char_beg[i]:=0;
         line_beg[i]:=0;
      
         char_end[i]:=0;
         line_end[i]:=0;
         
         no_tag[i]:=true;

      end;
      
   end;
   
   // now read the tex file, inserting each tag's text from the src file
   
   // assume no more than one tag per line in the tex file *and*
   // no more than one pair of matching tags per line in the src file
   
   reset(tex,file_name_tex);
   rewrite(out,file_name_out);
   
   for i:=1 to tex_tags.num_tag do with tex_tags do begin
      
      // skip lines that don't contain a tag in the tex file
      
      for j:=1 to num_skip_lines[i] do begin
         readln(tex,the_tex_line);
         writeln(out,the_tex_line);
      end;
      
      if no_tag[i] then begin
         
         // no matching tag found, so write out line (almost) as is
         
         readln(tex,the_tex_line);
         replace_tag(the_tex_line); // change \Btag to \Wtag so tex catches this error
         writeln(out,the_tex_line);
         
      end
      else begin
         
         // now we have a line with a tag in it, read the line and write out the lead-in chars
      
         readln(tex,the_tex_line);
         for j:=1 to tag_char[i] do write(out,the_tex_line[j]);
      
         // read the tag's text from the src file
      
         file_name_src:=tag_file[i];
         reset(src,file_name_src);
      
         for j:=1 to line_beg[i]-1 do readln(src);
         readln(src,the_src_line);
         if line_beg[i] <> line_end[i] then begin // Btag and Etag on separate lines
            for j:=char_beg[i]+1 to length(the_src_line) do write(out,the_src_line[j]);
            writeln(out);
            for j:=line_beg[i]+1 to line_end[i]-1 do begin
               readln(src,the_src_line);
               writeln(out,the_src_line);
            end;
            readln(src,the_src_line);
            for j:=1 to char_end[i] do write(out,the_src_line[j]);
         end
         else begin  // Btag and Etag on the one line
            for j:=char_beg[i]+1 to char_end[i] do write(out,the_src_line[j]);
         end;
         
         close(src);
      
         // write out remaining text for this tex line (the lead-out chars)
         
         for j:=tag_char[i]+length(file_name_src)+3 to length(the_tex_line) do write(out,the_tex_line[j]);
         writeln(out);
      
      end;
   
   end;
   
   // flush out any remain lines in the tex file (there will be no tag's in these lines)
   
   while not eof(tex) do begin
      readln(tex,the_tex_line);
      writeln(out,the_tex_line);
   end;
   
   close(tex);
   close(out);
   
end.
