program showTags(input,output);

const
   max_arg_num = 10;   
   max_arg_len = 128;
   max_tag_len  = 32;
   max_file_len = 128;
   max_num_char = 20000;
   max_num_save = 200;
   max_found_word = 100;
type
   set_of_char = set of char;
   tags_data   = record
                    num_tag  : integer;
                    tag      : array[1..max_num_save] of string[max_tag_len];
                    tag_char : array[1..max_num_save] of integer;
                    tag_line : array[1..max_num_save] of integer;
                 end;
var
   i,j            : integer;
   in_tex_comment : boolean;
   
   num_word       : integer;
   num_line       : integer;
   num_char       : integer;

   the_tag_key    : integer;
   the_tag_line   : integer;
   the_tag_char   : integer;
   the_tag_word   : string[max_tag_len];
   
   target         : string[max_tag_len];
   
   src_tags       : tags_data;
   
   src            : text;
   
   file_name      : string[255];
   
   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
{$include "cdb-parse.p"} 
(* -------------------------------------------------------------------------- *)

   procedure start_scan;
   begin
      
      first_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
   
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;

   end;

(* -------------------------------------------------------------------------- *)

   procedure next_scan;
   begin
      
      scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_key:=this_word_key;
         the_tag_char:=num_char;
         the_tag_line:=num_line;
      end;
            
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;

   end;
   
(* -------------------------------------------------------------------------- *)

   procedure final_scan;
   begin
      
      last_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_line:=num_line;
         the_tag_char:=num_char;
      end;
            
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure read_word(var word : string;
                           beg_word_chars : set_of_char;
                           end_word_chars : set_of_char);
   var
      dummy     : char;
      the_char  : char;
   begin
      
      while not (src^ in beg_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,dummy);
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
      read(src,dummy);
      num_char:=num_char+1;
      
      word:='';
      
      while not (src^ in end_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,the_char);
               word:=word+the_char;
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
   end;
      
(* -------------------------------------------------------------------------- *)

   procedure find_tags(var file_name : string);
   var
      i : integer;
      
      procedure process_word;
      begin
         read_word(the_tag_word,['{'],['}']);
         with src_tags do begin
            num_tag:=num_tag+1;
            tag[num_tag]:=keyword[the_tag_key]+'{'+the_tag_word+'}';
            tag_char[num_tag]:=the_tag_char+length(the_tag_word)+2;
            tag_line[num_tag]:=the_tag_line;
         end;
      end;
   
   begin
      
      keyword[1]:='\ref'; 
      keyword[2]:='\eqref'; 
      keyword[3]:='\label'; 
      keyword[4]:='\cite'; 
      keyword[5]:='\tag'; 

      num_keyword:=5;   

      new_keyword_tbl(num_keyword);

      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)
   
      reset(src,file_name);
   
      num_char:=0;
      num_line:=1;
      the_tag_line:=0;
      the_tag_char:=0;
      in_tex_comment:=false;
      
      src_tags.num_tag:=0;
   
      start_scan;

      while not eof(src) do begin
      
         if (found_word) and (not in_tex_comment) then begin
         
            process_word;
            start_scan;
         
         end
         else next_scan;
      
      end;

      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      close(src);
   
      with src_tags do begin
         // writeln('------------------------------------------------');
         // writeln(' num  line   char.     keyword');
         // writeln('------------------------------------------------');
         for i:=1 to num_tag do begin
            writeln(i:3,' ',tag_line[i]:5,' ',tag_char[i]:3,' ',tag[i],'');
         end;
         // writeln('------------------------------------------------');
      end;
   
   end;

(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      file_name:=cmd_line_arg[1];
      
   end;
   
begin
   
   initialize;
   
   find_tags(file_name);
      
end.
