const
   max_word_len = 20;
   max_num_word = 20;
type
   word_set_range   = 1..max_num_word;
   word_set         = set of 1..max_num_word;
   word_table_type  = array[1..max_num_word] of string[max_word_len];
   trans_table_type = array[1..max_word_len,char] of word_set;
var
   found_word     : boolean;
   did_read       : boolean;
   did_readln     : boolean;
   the_word       : string[255];
   this_char      : char;
   this_word      : string[255];
   this_word_set  : word_set;
   this_word_key  : integer;
   char_pos       : integer;
   word_table     : word_table_type;
   trans_table    : trans_table_type;
   num_keyword    : integer;
   
   keyword        : array[1..max_num_word] of string[max_word_len];

(* -------------------------------------------------------------------------- *)

   procedure new_keyword_tbl(var num_keyword : integer);
   var
      i,j : integer;
   begin

      for i:=1 to num_keyword do begin
         word_table[i]:='';
      end;
      
      for i:=1 to max_word_len do begin
         for j:=1 to 255 do begin
            trans_table[i,chr(j)]:=[];
         end;
      end;
   
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure add_keyword_tbl(new_word : string;
                             i : integer);
   var
      j : integer;
      k : word_set_range;
   begin
   
      k:=i;
   
      word_table[i]:=new_word;
      
      for j:=1 to length(word_table[i]) do begin
         trans_table[j,word_table[i,j]]:=trans_table[j,word_table[i,j]] + [k];
      end;
   
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure scan(var this_char     : char;
                  var char_pos      : integer;
                  var this_word     : string;
                  var this_word_set : word_set;
                  var this_word_key : integer;
                  var found_word    : boolean;
                  var word_was      : string;
                  var did_read      : boolean;
                  var did_readln    : boolean);
   var
      i : integer;
      next_char     : char;
      next_pos      : integer;
      next_word_set : word_set;
   begin

      did_read:=false;
      did_readln:=false;
      
      if eof(src) then begin
         
         // This code never executed -- see last_char_scan
                     
      end
      else begin
         
         if eoln(src) then begin
   
            readln(src);
            did_readln:=true;
            
            if card(this_word_set) = 1 then begin
               for i in this_word_set do this_word_key:=i;
               if this_word = word_table[this_word_key]
                  then found_word:=true
                  else found_word:=false;
            end
            else found_word:=false;
         
            if found_word then word_was:=word_table[this_word_key]
                          else word_was:='';
                          
            char_pos:=1;
            this_char:=' ';
            this_word:=this_char;
            this_word_set:=trans_table[1,this_char];

         end
         else begin
            
            next_char:=src^;                                   // look ahead to next char
            next_pos:=char_pos+1;

            next_word_set:=this_word_set * trans_table[next_pos,next_char];
      
            if next_word_set = [] then begin                   // a transition will occur
      
               if card(this_word_set) = 1 then begin           // we have a unique word
                  for i in this_word_set do this_word_key:=i;
                  if this_word = word_table[this_word_key]     // and it was in our table
                     then found_word:=true
                     else found_word:=false;
               end
               else found_word:=false;                         // not a unique word
               
               if found_word then begin                        // save the word

                  word_was:=word_table[this_word_key];

                  char_pos:=1;                                 // these lines here for info only
                  this_char:=next_char;                        // these vars will be reset by
                  this_word:=next_char;                        // immediate next call to 
                  this_word_set:=trans_table[1,next_char];     // start_scan in body of program
      
                  did_read:=false;
                  
               end
               else begin                                      // restart word search

                  word_was:='';
                  
                  // Need a bit of care here. Suppose the input stream consists of the
                  // following text
                  // 
                  //    ...abcdfeghABpqrtsuv...
                  //    
                  // end that the current word being tested is 'eghA'. Then we have
                  // this_char = 'A' and next_char = 'B'. We know that 'B' causes
                  // a transition to a non-keyword so we need to re-start the search.
                  // Big question : from where do we start the search? Do we start
                  // with 'B' or 'A'? Why do we ask this? Look at this case
                  // 
                  //    ...\abc\abc\def...
                  //    
                  // If \abc\def is a valid keyword then in the above we would have
                  // A = '\' and B = 'a' at the point where the search first failed
                  // (assuming \abc\a is not a valid keyword). If we restart with B 
                  // then we will miss this keyword. So in this case we need to restart
                  // with A. That is what the following is meant to do.
                  //
                  // All of this would be a non-issue if we knew or demanded that all
                  // keywords where separated by whitesapce.
      
                  if card(trans_table[1,this_char]) = 0 then begin
                     
                     // normal case, no keyword begins with this_char
                     
                     read(src,next_char);
                     did_read:=true;
                  
                     char_pos:=1;
                     this_char:=next_char;
                     this_word:=next_char;
                     this_word_set:=trans_table[1,next_char];
      
                  end
                  else begin
                      
                     // special case, one or more keywords begins with this_char
                     
                     char_pos:=1;
                     word_was:='';
                     this_char:=this_char;
                     this_word:=this_char;
                     this_word_set:=trans_table[1,this_char];

                     read(src,next_char);
                     did_read:=true;
                  
                     // we have two characters, are they from the same word?
                     // yes : build a word with this pair of characters
                     // no  : start a new word from next_char
                     
                     if card(trans_table[1,this_char] * trans_table[2,next_char]) <> 0 then begin
                     
                        char_pos:=2;
                        this_char:=next_char;
                        this_word:=this_word + next_char;
                        this_word_set:=this_word_set * trans_table[2,next_char];
                     
                     end
                     else begin
                        
                        char_pos:=1;
                        word_was:='';
                        this_char:=next_char;
                        this_word:=next_char;
                        this_word_set:=trans_table[1,next_char];

                     end;
                  
                  end;
      
               end;
      
            end
            else begin                                         // no transition, read next char
      
               read(src,this_char);
               did_read:=true;
                  
               char_pos:=char_pos+1;
               this_char:=this_char;
               this_word:=this_word + this_char;
               this_word_set:=this_word_set * trans_table[char_pos,this_char];
         
            end;
      
         end;
      
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure first_char_scan(var this_char     : char;
                             var char_pos      : integer;
                             var this_word     : string;
                             var this_word_set : word_set;
                             var this_word_key : integer;
                             var found_word    : boolean;
                             var word_was      : string;
                             var did_read      : boolean;
                             var did_readln    : boolean);
   begin

      did_read:=false;
      did_readln:=false;
      
      if eof(src) then begin
         
         this_char:=' ';
         
      end
      else begin
         
         if not eoln(src) then begin
   
            read(src,this_char);
            did_read:=true;
         
         end
         else begin
      
            readln(src);
            this_char:=' ';
            did_readln:=true;
         
         end;
      
      end;
      
      char_pos:=1;
      
      this_word:=this_char;
      this_word_set:=trans_table[char_pos,this_char];
   
      found_word:=false;
      word_was:='';

   end;

(* -------------------------------------------------------------------------- *)

   procedure last_char_scan(var this_char     : char;
                            var char_pos      : integer;
                            var this_word     : string;
                            var this_word_set : word_set;
                            var this_word_key : integer;
                            var found_word    : boolean;
                            var word_was      : string;
                            var did_read      : boolean;
                            var did_readln    : boolean);
   var
      i : integer;
   begin

      // This code handles the exceptional case where the input file finishes
      // with a matching keyword *without* a trailing \n  i.e.
      // 
      // ...<keyword><eof>
      // 
      // rather than
      //
      // ...<keyword><cr>
      // <eof>
      // 
      // this later case is handled by the procedure scan
         
      if eof(src) then begin
         
         if card(this_word_set) = 1 then begin
            for i in this_word_set do this_word_key:=i;
            if this_word = word_table[this_word_key]
               then found_word:=true
               else found_word:=false;
         end
         else found_word:=false;
      
         if found_word then word_was:=word_table[this_word_key]
                       else word_was:='';
                       
         char_pos:=1;
         this_char:=' ';
         this_word:=this_char;
         this_word_set:=trans_table[1,this_char];
         
      end;
      
   end;
