program cdbPstProc(input,output);
const
   max_arg_num = 10;   
   max_arg_len = 128;
   max_tag_len  = 32;
   max_num_char = 20000;
   max_num_save = 200;
   max_found_word = 100;
type
   set_of_char      = set of char;
   save_tags_data   = record
                         num_tag  : integer;
                         tag      : array[1..max_num_save] of string[max_tag_len];
                         tag_char : array[1..max_num_save] of integer;
                         tag_line : array[1..max_num_save] of integer;
                      end;
var
   i,j,k          : integer;
   keep_tags      : boolean;
   in_tex_comment : boolean;
   
   line_num       : integer;
   
   next_line      : boolean;
   
   num_line       : integer;
   num_char       : integer;
   the_tag_key    : integer;
   the_tag_line   : integer;
   the_tag_char   : integer;
   the_tag_word   : string[max_tag_len];
   
   tex_tags       : save_tags_data;
   
   src            : text;
   tex            : text;
   out            : text;
   
   file_name_tex  : string[255];
   file_name_out  : string[255];
   
   the_tex_line   : string[max_num_char];
   
   char_beg       : array[1..max_num_save] of integer;
   char_end       : array[1..max_num_save] of integer;
   line_tag       : array[1..max_num_save] of integer;
   
   num_skip_lines : array[1..max_num_save] of integer;
   
   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
{$include "cdb-parse.p"} 
(* -------------------------------------------------------------------------- *)

   procedure start_scan;
   begin
      
      first_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
   
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;

   end;

(* -------------------------------------------------------------------------- *)

   procedure next_scan;
   begin
      
      scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_key:=this_word_key;
         the_tag_char:=num_char;
         the_tag_line:=num_line;
      end;
            
      if did_read then num_char:=num_char + 1;
      if did_readln then begin
         num_char:=0;
         num_line:=num_line + 1;
         in_tex_comment:=false;
      end
      else begin
         if this_char = '%' then in_tex_comment:=true;
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure final_scan;
   begin
      
      last_char_scan(this_char,char_pos,this_word,this_word_set,this_word_key,found_word,the_word,did_read,did_readln);
      
      if found_word then begin
         the_tag_line:=num_line;
         the_tag_char:=num_char;
      end;
            
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure read_word(var word : string;
                           beg_word_chars : set_of_char;
                           end_word_chars : set_of_char);
   var
      dummy     : char;
      the_char  : char;
   begin
      
      while not (src^ in beg_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,dummy);
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
      read(src,dummy);
      num_char:=num_char+1;
      
      word:='';
      
      while not (src^ in end_word_chars) do begin
         if not eof(src) then begin
            if not eoln(src) then begin
               read(src,the_char);
               word:=word+the_char;
               num_char:=num_char+1;
            end
            else begin
               word:='';
               return;
            end;
         end
         else begin
            word:='';
            return;
         end;
      end;
      
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure find_tags_tex(var file_name : string);
                           
   var
      i : integer;
      
      procedure process_word;
      begin
         if ( keyword[the_tag_key] = '\Btag' ) 
         or ( keyword[the_tag_key] = '\Etag' ) then begin
            read_word(the_tag_word,['{'],['}']);
            with tex_tags do begin
               num_tag:=num_tag+1;
               tag[num_tag]:=keyword[the_tag_key]+'{'+the_tag_word+'}';
               tag_char[num_tag]:=the_tag_char+length(the_tag_word)+2;
               tag_line[num_tag]:=the_tag_line;
            end;
         end;
         if ( keyword[the_tag_key] = '\killL\left(' ) 
         or ( keyword[the_tag_key] = '\right)\killR' ) then begin
            with tex_tags do begin
               num_tag:=num_tag+1;
               tag[num_tag]:=keyword[the_tag_key];
               tag_char[num_tag]:=the_tag_char;
               tag_line[num_tag]:=the_tag_line;
            end;
         end;
         if ( keyword[the_tag_key] = '~"?"' ) then begin
            with tex_tags do begin
               num_tag:=num_tag+1;
               tag[num_tag]:=keyword[the_tag_key];
               tag_char[num_tag]:=the_tag_char;
               tag_line[num_tag]:=the_tag_line;
            end;
         end;
      end;
   
   begin
      
      keyword[1]:='\killL\left('; 
      keyword[2]:='\right)\killR';
      keyword[3]:='~"?"';
      keyword[4]:='\Btag'; 
      keyword[5]:='\Etag'; 

      if keep_tags then num_keyword:=3
                   else num_keyword:=5;   

      new_keyword_tbl(num_keyword);

      for i:=1 to num_keyword do add_keyword_tbl(keyword[i],i);

      (* --- read file and look for transitions --- *)
   
      reset(src,file_name);
   
      num_char:=0;
      num_line:=1;
      the_tag_line:=0;
      the_tag_char:=0;
      in_tex_comment:=false;
      
      tex_tags.num_tag:=0;
   
      start_scan;
      
      while not eof(src) do begin
         
         if (found_word) and (not in_tex_comment) then begin
         
            process_word;
            start_scan;
         
         end
         else next_scan;
            
      end;

      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><cr>
      // <eof>
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      // This handles the case where the input file finishes like this
      // 
      // ...<keyword><eof>

      final_scan;
   
      if (found_word) and (not in_tex_comment) then process_word;
   
      close(src);
   
      // with tex_tags do begin
      //    for i:=1 to num_tag do begin
      //       writeln(i:3,' ',tag_line[i]:3,' ',tag_char[i]:3,' !',tag[i],'!');
      //    end;
      // end;
   
   end;

(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      file_name_tex:=cmd_line_arg[1]+".tex";
      file_name_out:=cmd_line_arg[1]+".notag";
      
      if cmd_line_num > 1 then keep_tags:=true
                          else keep_tags:=false;
      
   end;
   
begin
   
   initialize;
   
   // read the tags in the tex file. 
   // the text for these tags will be replaced by text drawn from the src file
      
   find_tags_tex(file_name_tex);
   
   // compute beg/end pairs for reading text from the tex and src files
   
   num_skip_lines[1]:=max(0,tex_tags.tag_line[1] - 1);
   
   for i:=2 to tex_tags.num_tag do with tex_tags do begin
      num_skip_lines[i]:=max(0,tag_line[i] - tag_line[i-1] - 1);
   end;
      
   for i:=1 to tex_tags.num_tag do with tex_tags do begin
      
      char_beg[i]:=tag_char[i] - length(tag[i]) + 1;
      char_end[i]:=tag_char[i];
      line_tag[i]:=tag_line[i];
      
   end;
   
   // now read the tex file, skipping each tag's text from the tex file
   
   // assume that tags are never split over two lines
   
   reset(tex,file_name_tex);
   rewrite(out,file_name_out);
   
   i:=1; // the tag number
   
   line_num:=0;
   
   while i <= tex_tags.num_tag do with tex_tags do begin
      
      // skip lines that don't contain a tag in the tex file
      
      for j:=1 to num_skip_lines[i] do begin
         readln(tex,the_tex_line);
         writeln(out,the_tex_line);
         line_num:=line_num+1;
      end;
      
      // now we have a line with one or more tags in it, read/write the line, skip the tags
   
      readln(tex,the_tex_line);
      line_num:=line_num+1;
      
      j:=1;
      next_line:=false;
      
      while (j <= length(the_tex_line)) and (not next_line) do begin
         
         if (j < char_beg[i]) then write(out,the_tex_line[j]);
         if (j = char_end[i]) then begin // move to next tag
            i:=i+1;
            if line_num <> line_tag[i] then begin // next tag not on this line
               for k:=j+1 to length(the_tex_line) do write(out,the_tex_line[k]);
               next_line:=true;
            end;
         end;
         
         j:=j+1;
         
      end;
      
      writeln(out);
      
   end;
   
   // flush out any remain lines in the tex file (there will be no tag's in these lines)
   
   while not eof(tex) do begin
      readln(tex,the_tex_line);
      writeln(out,the_tex_line);
   end;
   
   close(tex);
   close(out);
   
end.
