\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cadabra}
\LoadClassWithOptions{article}
%-------------------------------------------------------------------------------
\usepackage{ifpdf}
\ifpdf
\usepackage[pdftex]{graphicx}
\usepackage[usenames,dvipsnames]{color}
\else
\usepackage{graphicx}
\usepackage[usenames,dvips]{color}
\fi
\usepackage{amsmath}
%\usepackage{amssymb}
%\usepackage{fancyvrb}
\usepackage{listings}
\usepackage{breqn}
%\usepackage{tableaux}
\def\coloneql{\mathrel{\mathop{:}}\hspace{-.5em}{}=}
\renewcommand{\bar}[1]{\overline{#1}}
%-------------------------------------------------------------------------------
\definecolor{cdbcode}{named}{RoyalBlue}
\definecolor{cdbeqtn}{named}{Black}
\definecolor{cdbprint}{named}{Black}
\definecolor{cdberror}{named}{Red}
\definecolor{cdbcomment}{named}{Red}
\definecolor{cdbmessage}{named}{Tan}
\definecolor{cdbverbatim}{named}{RoyalBlue}
%-------------------------------------------------------------------------------
\def\cdberrorbefore{\vskip   2pt plus 2pt minus 1pt}
\def\cdberrorafter{\vskip   10pt plus 2pt minus 1pt}
\def\cdbeqtnbefore{\vskip  -10pt plus 4pt minus 2pt}
\def\cdbeqtnafter{\vskip     0pt plus 2pt minus 1pt}
\def\cdbprintbefore{\vskip -10pt plus 4pt minus 2pt}
\def\cdbprintafter{\vskip    0pt plus 2pt minus 1pt}
%-------------------------------------------------------------------------------
\def\cdbslash{{\tt\char'134}}
\def\cdbhash{{\tt\char'043}}
\def\@cdberror#1{\centerline{\vbox{\color{cdberror}\halign{\hfil##\hfil\cr#1}}}}
\def\cdberror#1{\cdberrorbefore\@cdberror{ERROR{}{#1}\cr}\cdberrorafter}
\def\cdbeqtn#1#2{\cdbeqtnbefore\begin{dmath*}[compact, spread=2pt]\color{cdbeqtn}#1\coloneql#2\end{dmath*}\cdbeqtnafter}
\def\cdbprint#1{\cdbprintbefore\begin{dmath*}[compact, spread=2pt]\color{cdbprint}#1\end{dmath*}\cdbprintafter}
\def\cdbmessage#1#2{\hbox{\color{cdbmessage}{\tt #1}: {\it #2}}}
\def\cdbmessagesOn{\gdef\cdbmessage##1##2{\hbox{\color{cdbmessage}{\tt ##1}: {\it ##2}}}}
\def\cdbmessagesOff{\gdef\cdbmessage##1##2{\relax}}
%-------------------------------------------------------------------------------
\def\cdblt{\hbox{\tt <}}
\def\cdbgt{\hbox{\tt >}}
\def\cdbpcent{\hbox{\char'045}}
\def\cdbunder{\hbox{\tt _}}
\def\cdbtilde{\lower0pt\hbox{\normalfont$\sim\!\!$}}
%-------------------------------------------------------------------------------
\def\verbatim@font{\color{cdbverbatim}\normalfont\ttfamily}
%-------------------------------------------------------------------------------
\lstnewenvironment{cdbcomment} 
{\lstset{language=C,aboveskip=4pt plus 3pt minus 1pt,belowskip=2pt,mathescape,
                   linewidth=0.95\textwidth,basewidth={0.5em},showstringspaces=false,
                   basicstyle={\ttfamily\color{cdbcomment}}}}{}
%-------------------------------------------------------------------------------
\lstnewenvironment{cdbverbatim} 
{\lstset{language=C,aboveskip=4pt plus 3pt minus 1pt,belowskip=2pt,
                   linewidth=0.95\textwidth,basewidth={0.5em},showstringspaces=false,
                   basicstyle={\ttfamily\color{cdbverbatim}}}}{}
%-------------------------------------------------------------------------------
\lstnewenvironment{cdbcode} 
{\lstset{language=C,aboveskip=10pt plus 3pt minus 1pt,belowskip=2pt,
                   linewidth=0.99\textwidth,basewidth={0.5em},showstringspaces=false,
                   xleftmargin=20pt,
                   morecomment=[f][\color{cdbcomment}][0]{\#},
                   basicstyle={\small\ttfamily\color{cdbcode}}}}{}
%-------------------------------------------------------------------------------
\def\TitleFooter{{\lower 0.5cm\hbox to \textwidth{\normalfont\hfill\small}}}
\def\TitleHeader{{\hbox to \textwidth{\hfill}}}
\def\NormalFooter{{\lower 0.5cm\hbox to \textwidth{\normalfont\hfill\small\thepage}}}
\def\NormalHeader{{\hbox to \textwidth{\hfill}}}
%-------------------------------------------------------------------------------
\newcommand*{\ps@CDBtitle}{%
\renewcommand*{\@oddhead}{\TitleHeader\hfill}
\renewcommand*{\@evenhead}{\TitleHeader\hfill}
\renewcommand*{\@oddfoot}{\TitleFooter\hfill}
\renewcommand*{\@evenfoot}{\TitleFooter\hfill}}
%-------------------------------------------------------------------------------
\newcommand*{\ps@CDBnormal}{%
\renewcommand*{\@oddhead}{\NormalHeader\hfill}
\renewcommand*{\@evenhead}{\NormalHeader\hfill}
\renewcommand*{\@oddfoot}{\NormalFooter\hfill}
\renewcommand*{\@evenfoot}{\NormalFooter\hfill}}
%-------------------------------------------------------------------------------
\pagestyle{CDBnormal}
\thispagestyle{CDBtitle}
%-------------------------------------------------------------------------------
\hoffset=-1in
\voffset=-1in
\newdimen\marginright
\newdimen\marginleft
\newdimen\margintop
\newdimen\marginbottom
\def\@true{1}
\def\@false{0}
\def\cdbPapersizewasset{\@false}
\def\papersize#1#2#3#4#5#6{% height, width, left, right, top, bottom margins
\paperheight=#1%
\paperwidth=#2%
\marginleft=#3%
\marginright=#4%
\margintop=#5%
\marginbottom=#6%
\setlength\headheight{0pt}
\setlength\headsep{0pt}
\setlength\footskip{1cm}
\setlength{\textwidth}{\paperwidth}
\addtolength{\textwidth}{-\marginleft}
\addtolength{\textwidth}{-\marginright}
\setlength{\textheight}{\paperheight}
\addtolength{\textheight}{-\margintop}
\addtolength{\textheight}{-\marginbottom}
\addtolength{\textheight}{-\headheight}
\addtolength{\textheight}{-\headsep}
\addtolength{\textheight}{-\footskip}
\setlength{\oddsidemargin}{\marginleft}
\setlength{\evensidemargin}{\marginleft}
\setlength{\topmargin}{\margintop}
\ifpdf
\setlength{\pdfpageheight}{\paperheight}%
\setlength{\pdfpagewidth}{\paperwidth}
\else
\special{papersize=\the\paperwidth,\the\paperheight}
\fi
\gdef\cdbPapersizewasset{\@true}}
%-------------------------------------------------------------------------------
\def\cdbDefaultPapersize{\papersize{210mm}{297mm}{2cm}{2cm}{2cm}{2cm}}% A4 landscape, screen only, rotate before printing
%-------------------------------------------------------------------------------
\parindent=0pt
\parskip=8pt plus 2pt minus 1pt
%-------------------------------------------------------------------------------
\InputIfFileExists{\jobname.cfg}{}{}
\if\cdbPapersizewasset\@false
\cdbDefaultPapersize
\fi
\def\papersize#1#2#3#4#5#6{\relax}% now we kill \papersize, why? beacuse only first \special{papersize...} used by dvipdf
%-------------------------------------------------------------------------------
% sample your-file.cfg file
%
% \papersize{210mm}{297mm}{2cm}{2cm}{2cm}{2cm}% custom papersize, height, width, l,r,t,b margins
%
% \def\diff#1\,_#2{\partial_{#2}#1}% because LaTeXForm not exported in command line form of cadabra
%-------------------------------------------------------------------------------
