program cdbPreproc(input,output);
const
   max_arg_num = 10;   
   max_arg_len = 128;
   max_num_char = 20000;
type
   set_of_char = set of char;
var
   
   ignore_line          : boolean;
   in_latex_block       : boolean;
   leaving_latex_block  : boolean;
   entering_latex_block : boolean;
   
   this_line      : string[max_num_char];

   src            : text;
   cdb            : text;
   
   cmd_line_num   : integer;
   cmd_line_arg   : array[0..max_arg_num] of string[max_arg_len];
   
   cdb_file       : string[255];
   src_file       : string[255];

(* -------------------------------------------------------------------------- *)
{$include "cdb-string.p"}
(* -------------------------------------------------------------------------- *)

   procedure get_word(var word   : string;
                      var source : string;
                      var offset : integer;
                      var found  : boolean;
                          white_space : set_of_char;
                          delimeters  : set_of_char);
   var
      i         : integer;
      len       : integer;
      start     : integer;
      finish    : integer;
   begin
      found:=false;
      len:=length(source);
      if offset <= len then begin
         // skip leading white space
         start:=offset;
         for i:=offset to len do begin
            if not( source[i] in white_space ) then begin
               start:=i;
               break;
            end;
         end;
         // now get the word
         finish:=len;
         for i:=start to len do begin
            if not( source[i] in delimeters ) then finish:=i
                                              else break;
         end;
         setlength(word,finish-start+1);
         for i:=start to finish do begin
            word[i-start+1]:=source[i];
            found:=true;
         end;
         offset:=finish+2;
      end
      else word:='';
   end;
   
(* -------------------------------------------------------------------------- *)

   procedure do_inline;
      // process a line of the form
      //     %inline{file-name}: text
   var
      i : integer;
      offset : integer;
      found  : boolean;
      dummy     : string[255];
      the_tail  : string[255];
      file_name : string[255];
   begin
      // get the file name
      offset:=1;
      get_word(dummy,this_line,offset,found,[' '],['{']);
      get_word(file_name,this_line,offset,found,[' '],['}']);
      strip_quotes(file_name);
      trim(file_name);
      // get any trailing text
      the_tail:='';
      for i:=offset+1 to length(this_line) do the_tail:=the_tail + this_line[i];
      trim(the_tail);
      // write out standard cadabra text
      writeln(cdb,'< "',file_name,'"');
      writeln(cdb,the_tail);
   end;

(* -------------------------------------------------------------------------- *)

   procedure initialize;
   var
      i : integer;
   begin
      
      for i:=0 to ParamCount do begin
         cmd_line_arg[i]:=ParamStr(i);
         trim(cmd_line_arg[i]);
      end;
      
      cmd_line_num:=ParamCount;
      
      src_file:=cmd_line_arg[1]+".cdbp";
      cdb_file:=cmd_line_arg[1]+".cdb";
      
   end;
   
begin
   
   initialize;
   
   reset(src,src_file);
   rewrite(cdb,cdb_file);
   
   in_latex_block:=false;

   while not eof(src) do begin
      
      readln(src,this_line);
      
      trim_tail(this_line);
      
      ignore_line:=false;
      leaving_latex_block:=false;
      entering_latex_block:=false;

      if match_word(this_line,'%(') then ignore_line:=true;
      if match_word(this_line,'%)') then ignore_line:=true;
         
      if match_word(this_line,'%inline') then begin
         do_inline;
         ignore_line:=true;
      end;
      
      if in_latex_block then begin
         
         if match_word(this_line,'%<') then ignore_line:=true;
                                       
         if match_word(this_line,'%>') then begin
            leaving_latex_block:=true;
         end
         else begin
            leaving_latex_block:=false;
            if not match_word(this_line,'%%') then this_line:='%%' + this_line;
         end;
         
      end
      else begin
         
         if match_word(this_line,'%>') then ignore_line:=true;
                                       
         if match_word(this_line,'%<') then begin
            entering_latex_block:=true;
         end
         else begin
            entering_latex_block:=false;
         end;
         
      end;
      
      if not ignore_line then writeln(cdb,this_line);
      
      if entering_latex_block then in_latex_block:=true;
      if leaving_latex_block then in_latex_block:=false;
         
   end;
   
   close(src);
   close(cdb);
      
end.
