// This file uses unofficial extensions of POV-Ray 3.5 -------------------------

//#version unofficial "LCB-Pov" 0.01;

// -----------------------------------------------------------------------------

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>// *0.3  // to reduce overall brightness
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

//     Choose a colour which is close to that of the intended background

background { color <1.0,1.0,1.0> }

#declare beg_location = < -90, 250,0 >;  // start of camera's journey
#declare end_location = < +90,-100,0 >;  // end of camera's journey

#declare beta = 0.95;           // a fraction of the speed of light

#declare rotate_z_angle =  60;  // angle to rotate cube about z-axis
                                // followed by
#declare rotate_x_angle = -40;  // angle to rotate cube about x-axis
                                // default has the cube aligned with axes

#declare displacement = end_location - beg_location;

#declare camera_velocity = beta*displacement/vlength(displacement);

// Note all camera parameters, apart from velocity, refer to a momentarily 
// stationary camera in the scene frame. They thus describe rest properties 
// of the camera.

camera {
  velocity   camera_velocity
  location   beg_location + clock*displacement
  sky        < 0.0, 0.0, 1.0> // right handed-system 
  up         < 0.0, 0.0, 1.0> // Z is up, y out of screen, x points left
  right      < image_width/image_height, 0.0, 0.0>         // Sets aspect ratio
  angle      70.0000          // approximately a 28 mm lens
  look_at  <-40000000,-200000,0>      // far away so camera points in one direction
                              // throughout its journey
                              // also swung around so cube stars its journey
                              // close to the left edge of the frame
}

//
// *******  L I G H T S *******
//

light_source {   // Light004
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  70.0*z
}

light_source {   // Light006
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  -70.0*y
}

light_source {   // Light005
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  70.0*y
}

light_source {   // Light003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  -70.0*x
}

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  70.0*x
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  translate  -70.0*z
}

//
// ********  MATERIALS  *******
//

#include "include/rubik.inc"

//
// ********  OBJECTS  *******
//

union { // The complete Rubik's cube

union { // Group006
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidBlue
  }
  rotate -90.0*y
  translate  -20.0*x
}


union { // Group005
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidYellow
  }
  rotate 90.0*x
  translate  -20.0*y
}


union { // Group004
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidOrange
  }
  rotate 90.0*y
  translate  20.0*x
}


union { // Group003
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidRed
  }
  rotate -90.0*x
  translate  20.0*y
}


union { // Group002
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidGreen
  }
  translate  20.0*z
}


union { // Group001
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  0.001*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 0.0, 0.001>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, 13.0, 0.001>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, 13.0, 0.001>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 13.0, 0.001>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, 0.0, 0.001>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <-13.0, -13.0, 0.001>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <0.0, -13.0, 0.001>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 6.0, 0.001>
    translate  <13.0, -13.0, 0.001>
  }
  material {
    SolidWhite
  }
  rotate -180.0*y
  translate  -20.0*z
}

box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  material {
    SolidBlack
  }
  scale 20.0
}

rotate z*rotate_z_angle
rotate x*rotate_x_angle
}


