// This file uses unofficial extensions of POV-Ray 3.5 -------------------------

#version unofficial "LCB-Pov" 0.01;

// -----------------------------------------------------------------------------

/* --- LCB --- 16 Sep 2002 -------------------------------------------------- */

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>// *0.3  // to reduce overall brightness
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

/* -----------------------------------------------------------------------------
   This does *not* record the same flight as the zero-c flight.
   In this case the abberation is extreme and so the angle by which we rotate
   the camera is much higher than before. This also requires a change in the
   clock values; 0.75 to 1.5 gives a reasonable sequence. These tweak factors
   were determined on an ad hoc basis, I think I should be able to do a better
   job!
----------------------------------------------------------------------------- */

background { color <0.000,0.000,0.000> }

#include "source/earth.inc"
#include "source/moon.inc"

#declare beta = 0.95;           // a fraction of the speed of light

#declare beg_location = < -2000.0, 0,  200000 >;  // start of camera's journey
#declare end_location = < +10000.0, 0, -20000 >;  // end of camera's journey

#declare displacement = end_location - beg_location;
#declare my_location  = beg_location + clock*displacement;

#declare camera_velocity = beta*displacement/vlength(displacement);

/* -----------------------------------------------------------------------------
   I want a sequence in which the objects enter from the left of the screen and
   later exit from the right of the screen. I do this by first placing the
   Earth at the centre of the image. The I rotate the camera by one half of its
   field of view, thus pushing the Earth to the left edge of the screen.
   (Actually I have to use a slightly larger angle because the Earth has a
   finite size.)
   
   Also, make sure the my_look_at is way behind all objects, hence
   the huge scale factor.
----------------------------------------------------------------------------- */

#declare my_angle = 1.5;  // rotate the camera way off the direction of motion
#declare my_look_at = -200000000*<sin(my_angle),0,cos(my_angle)>;

camera{                              
  velocity   camera_velocity
  location   beg_location + clock*displacement
  up         <0,1,0>                // Z out of the screen, X to the left, Y up.
  right      < 1.33, 0.0, 0.0>      // Default width to height ratio
  angle      28                     // Field of view in camera
  look_at    my_look_at
}

object {Earth rotate <0,220,0> translate <-2000,0,-10000>}
object {moon rotate <0,80,0> translate <-3000,0,-100000>}
