// This file uses unofficial extensions of POV-Ray 3.5 -------------------------

#version unofficial "LCB-Pov" 0.01;

// -----------------------------------------------------------------------------

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>// *0.3  // to reduce overall brightness
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

// --- Details of the coarse sequence

#declare coarse_num_frame = 100;

#declare coarse_beg_loc = -500;
#declare coarse_end_loc = 3000;

// --- Set target details for the sub-sequence

#declare target_beg_frame = 19;    // Tardis 2
#declare target_end_frame = 47.3;  // Tardis 3, tweaked to get better registration

#declare beg_location = ( coarse_beg_loc*(coarse_num_frame-1-target_beg_frame) + coarse_end_loc*(target_beg_frame) )/(coarse_num_frame-1);
#declare end_location = ( coarse_beg_loc*(coarse_num_frame-1-target_end_frame) + coarse_end_loc*(target_end_frame) )/(coarse_num_frame-1);

// --- Clock from 0 to 1 will take the camer over the desired journey

#declare the_location = (1-clock)*beg_location + clock*end_location;

camera {
  velocity  <0, 0, 0 >
  location  <0, the_location, 300>
  sky       <0.0, 0.0, 1.0>        // Use right handed-system 
  up        <0.0, 0.0, 1.0>        // Where Z is up
  right     <1.33, 0.0, 0.0>       // Default width to height ratio
  angle     36                     //
  look_at   <0, 10000, 300>        // Look into the screen
}

//
// *******  L I G H T S *******
//

// --- The lights are carefully tailored to avoid multiple shadows

#declare z_height = 700.00;
#declare my_offset = <0, 000, 0>;
#declare my_fade_distance = 600;
#declare my_fade_power = 3.0;

light_source {   // light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, -1500, z_height>
  translate  my_offset
}

light_source {   // light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, -500, z_height>
  translate  my_offset
}

light_source {   // light003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 500, z_height>
  translate  my_offset
}

light_source {   // light004
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 1500, z_height>
  translate  my_offset
}

light_source {   // light005
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 2500, z_height>
  translate  my_offset
}

light_source {   // light006
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 3500, z_height>
  translate  my_offset
}

light_source {   // light007
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 4500, z_height>
  translate  my_offset
}

light_source {   // light008
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 5500, z_height>
  translate  my_offset
}

light_source {   // light009
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 6500, z_height>
  translate  my_offset
}

light_source {   // light010
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 7500, z_height>
  translate  my_offset
}

light_source {   // light011
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 8500, z_height>
  translate  my_offset
}

light_source {   // light012
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 9500, z_height>
  translate  my_offset
}

light_source {   // light013
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance my_fade_distance
  fade_power my_fade_power
  translate  <0, 10500, z_height>
  translate  my_offset
}

//
// ********  MATERIALS  *******
//

#include "source/tardis_x.inc"

//
// ********  REFERENCED OBJECTS  *******
//

//
// ********  OBJECTS  *******
//

#include "source/tardis_p.inc"

#declare P_Base_Ref = object {
  P_Base
}
#declare P__6_Ref = object {
  P__6
}
#declare P__1_Ref = object {
  P__1
}
#declare P__5_Ref = object {
  P__5
}
#declare P___Ref = object {
  P__
}
#declare P__2_Ref = object {
  P__2
}
#declare P__3_Ref = object {
  P__3
}
#declare P__4_Ref = object {
  P__4
}
#declare P__7_Ref = object {
  P__7
}
#declare P_Sign1Off_Ref = object {
  P_Sign1Off
}
#declare P_Sign1On_Ref = object {
  P_Sign1On
}
#declare P_Sign2Off_Ref = object {
  P_Sign2Off
}
#declare P_Sign2On_Ref = object {
  P_Sign2On
}
#declare P_Sign3Off_Ref = object {
  P_Sign3Off
}
#declare P_Sign3On_Ref = object {
  P_Sign3On
}
#declare P_Sign4Off_Ref = object {
  P_Sign4Off
}
#declare P_Sign4On_Ref = object {
  P_Sign4On
}
#declare P_SlopeRoof_Ref = object {
  P_SlopeRoof
}
#declare P_Roof_Ref = object {
  P_Roof
}
#declare P_Roof1_Ref = object {
  P_Roof1
}
#declare P_Sbox_Ref = object {
  P_Sbox
}
#declare P_Sbox1_Ref = object {
  P_Sbox1
}
#declare P_Sbox2_Ref = object {
  P_Sbox2
}
#declare P_Sbox3_Ref = object {
  P_Sbox3
}
#declare P_TopLightCo_Ref = object {
  P_TopLightCo
}
#declare P_Cylin1_Ref = object {
  P_Cylin1
}
#declare P_Cylin_Ref = object {
  P_Cylin
}
#declare P_Cylin2_Ref = object {
  P_Cylin2
}
#declare P_Cylinder_Ref = object {
  P_Cylinder
}
#declare P_TopLight_Ref = object {
  P_TopLight
}
#declare P_Wfram4_Ref = object {
  P_Wfram4
}
#declare P_Windo6_Ref = object {
  P_Windo6
}
#declare P_PanelD_Ref = object {
  P_PanelD
}
#declare P_Panelframe_Ref = object {
  P_Panelframe
}
#declare P_Handl_Ref = object {
  P_Handl
}
#declare P_Screw1_Ref = object {
  P_Screw1
}
#declare P_Screw1__Ref = object {
  P_Screw1_
}
#declare P_Door1_Ref = object {
  P_Door1
}
#declare P_DoorStrip1_Ref = object {
  P_DoorStrip1
}
#declare P_LockCover_Ref = object {
  P_LockCover
}
#declare P_Window_Ref = object {
  P_Window
}
#declare P_Wfram5_Ref = object {
  P_Wfram5
}
#declare P_Door_Ref = object {
  P_Door
}
#declare P_Handle_Ref = object {
  P_Handle
}
#declare P_Screw_Ref = object {
  P_Screw
}
#declare P_Screw2__Ref = object {
  P_Screw2_
}
#declare P_WframeD_Ref = object {
  P_WframeD
}
#declare P_Windo5_Ref = object {
  P_Windo5
}
#declare P_DoorStrip2_Ref = object {
  P_DoorStrip2
}
#declare P_Door6_Ref = object {
  P_Door6
}
#declare P_Wfram1_Ref = object {
  P_Wfram1
}
#declare P_Windo_Ref = object {
  P_Windo
}
#declare P_Door2_Ref = object {
  P_Door2
}
#declare P_Wfram2_Ref = object {
  P_Wfram2
}
#declare P_Windo1_Ref = object {
  P_Windo1
}
#declare P_Door3_Ref = object {
  P_Door3
}
#declare P_DoorStrip3_Ref = object {
  P_DoorStrip3
}
#declare P_Wfram3_Ref = object {
  P_Wfram3
}
#declare P_Windo2_Ref = object {
  P_Windo2
}
#declare P_Door5_Ref = object {
  P_Door5
}
#declare P_Wfram_Ref = object {
  P_Wfram
}
#declare P_Windo3_Ref = object {
  P_Windo3
}
#declare P_DoorStrip4_Ref = object {
  P_DoorStrip4
}
#declare P_Door7_Ref = object {
  P_Door7
}
#declare P_Windo4_Ref = object {
  P_Windo4
}
#declare P_Door4_Ref = object {
  P_Door4
}
#declare P_Wframe_Ref = object {
  P_Wframe
}

#declare Base_Tardis_Ref = object {

union { // tardis_group
  object { P_Base_Ref }
  object { P__6_Ref }
  object { P__1_Ref }
  object { P__5_Ref }
  object { P___Ref }
  object { P__2_Ref }
  object { P__3_Ref }
  object { P__4_Ref }
  object { P__7_Ref }
  object { P_Sign1Off_Ref }
  object { P_Sign1On_Ref }
  object { P_Sign2Off_Ref }
  object { P_Sign2On_Ref }
  object { P_Sign3Off_Ref }
  object { P_Sign3On_Ref }
  object { P_Sign4Off_Ref }
  object { P_Sign4On_Ref }
  object { P_SlopeRoof_Ref }
  object { P_Roof_Ref }
  object { P_Roof1_Ref }
  object { P_Sbox_Ref }
  object { P_Sbox1_Ref }
  object { P_Sbox2_Ref }
  object { P_Sbox3_Ref }
  object { P_TopLightCo_Ref }
  object { P_Cylin1_Ref }
  object { P_Cylin_Ref }
  object { P_Cylin2_Ref }
  object { P_Cylinder_Ref }
  object { P_TopLight_Ref }
  object { P_Wfram4_Ref }
  object { P_Windo6_Ref }
  object { P_PanelD_Ref }
  object { P_Panelframe_Ref }
  object { P_Handl_Ref }
  object { P_Screw1_Ref }
  object { P_Screw1__Ref }
  object { P_Door1_Ref }
  object { P_DoorStrip1_Ref }
  object { P_LockCover_Ref }
  object { P_Window_Ref }
  object { P_Wfram5_Ref }
  object { P_Door_Ref }
  object { P_Handle_Ref }
  object { P_Screw_Ref }
  object { P_Screw2__Ref }
  object { P_WframeD_Ref }
  object { P_Windo5_Ref }
  object { P_DoorStrip2_Ref }
  object { P_Door6_Ref }
  object { P_Wfram1_Ref }
  object { P_Windo_Ref }
  object { P_Door2_Ref }
  object { P_Wfram2_Ref }
  object { P_Windo1_Ref }
  object { P_Door3_Ref }
  object { P_DoorStrip3_Ref }
  object { P_Wfram3_Ref }
  object { P_Windo2_Ref }
  object { P_Door5_Ref }
  object { P_Wfram_Ref }
  object { P_Windo3_Ref }
  object { P_DoorStrip4_Ref }
  object { P_Door7_Ref }
  object { P_Windo4_Ref }
  object { P_Door4_Ref }
  object { P_Wframe_Ref } }
}

 object {Base_Tardis_Ref rotate +90*z translate 0*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 1000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 2000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 3000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 4000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 5000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 6000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 7000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 8000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 9000*y-400*x }
 object {Base_Tardis_Ref rotate +90*z translate 10000*y-400*x }

 object {Base_Tardis_Ref rotate -90*z translate 0*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 1000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 2000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 3000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 4000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 5000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 6000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 7000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 8000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 9000*y+400*x }
 object {Base_Tardis_Ref rotate -90*z translate 10000*y+400*x }

