
// --- Sky 1 -------------------------------------------------------------------

/* --------------------------------------------------------------------------
     The parlemnt_x.pov scene has a global ambient value set at 0.3. This is
     to emphasize the shadows generated by the standard light source.
     However, the 'sky' will, at this ambient lightlevel, appear very dark
     (thunderstorms over our fair capital?). To counter this I set the
     ambient value for the sky at 3.33.
   -------------------------------------------------------------------------- */

#declare FBM_Clouds =
pigment {
    bozo
    turbulence 0.65
    octaves 4
    omega 0.7
    lambda 2
    color_map {
        [0.0 rgb 0.85]
        [0.1 rgb 0.75]
        [0.5 rgbt 1]
    }
    scale <1, 1, 1>
}

// Small puffs of white clouds
#declare Sky1 =
texture {                          // The blue sky background for the clouds 
    pigment { rgb <0.196078, 0.6, 0.8> }
    finish { ambient 3.33*0.9 diffuse 0 }
}
texture {                          // The upper part of the clouds
    pigment { FBM_Clouds }
    finish { ambient 3.33*1.0 diffuse 0 }
}
texture {                          // The darker underside of the clouds
    pigment { FBM_Clouds  translate -0.15*y }
    finish { ambient 3.33*0.6 diffuse 0 }
}

sphere
{
    <0, 0, 0>, 30
    hollow on
    texture 
    {
      Sky1
      finish {diffuse 0 ambient 3.33*1}
      scale <+30, +30, +30>*0.5
    }
}
