// This file uses unofficial extensions of POV-Ray 3.5 -------------------------

#version unofficial "LCB-Pov" 0.01;

// -----------------------------------------------------------------------------

default {
  texture {
//  pigment { rgb <1,0,0> }
    pigment { rgb <0.87,0.13,0.02> }
  }
}

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>// *0.3  // to reduce overall brightness
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

/* --------------------------------------------------------------------------
      We want a movie where the train is seen *in the camera frame* to
      travel perpendicular to the line of sight (in the camera frame)
      To acheive this I transform, from the camera frame to the scene
      frame, the start and finish *events* as well as the null
      4-vector for the viewing direction.
      
      Target object is at <0,0,0> in the scene frame.
  --------------------------------------------------------------------------- */

#declare L_y = 400;               // minimum distance to object
#declare beta = 0.95;             // fraction of speed of light
#declare the_alpha = 0.95;        // very approximately 35 degrees, exceeds
                                  // camera viewing angle so that the object
                                  // makes a clear entry and exit from the
                                  // camera frame

#declare the_v = <beta,0,0>;      // 3-velocity of camera frame

#declare v_sq = vdot(the_v,the_v);

#declare gamma = 1/sqrt(1-v_sq);

/* --- set the start and end times of the animation in the camera frame ----- */

#declare beg_t_dash = L_y*(beta-sin(the_alpha))/(beta*cos(the_alpha));
#declare end_t_dash = L_y*(beta+sin(the_alpha))/(beta*cos(the_alpha));

/* --- camera is fixed in the camera frame ---------------------------------- */

#declare beg_x_dash = <0, 1, 0>*L_y;    // location of camera in camera frame
#declare end_x_dash = <0, 1, 0>*L_y;    // location of camera in camera frame

/* --- camera viewing direction is along the y-dash axis -------------------- */

#declare w_dash = <0, -200000, 0>;      // viewing direction in camera frame
#declare wt_dash = -vlength(w_dash);    // and its a null 4-vector

/* --- Lorentz transformations from camera to scene frame ------------------- */

/* --- start of journey --- */

#declare v_dot_x = vdot(the_v,beg_x_dash);

#declare tmp_x = beg_x_dash.x + gamma*the_v.x*beg_t_dash + the_v.x*(gamma-1)*v_dot_x/v_sq;
#declare tmp_y = beg_x_dash.y + gamma*the_v.y*beg_t_dash + the_v.y*(gamma-1)*v_dot_x/v_sq;
#declare tmp_z = beg_x_dash.z + gamma*the_v.z*beg_t_dash + the_v.z*(gamma-1)*v_dot_x/v_sq;
#declare beg_location = <tmp_x, tmp_y, tmp_z >;
#declare beg_t = gamma*(beg_t_dash + v_dot_x);

/* --- end of journey --- */

#declare v_dot_x = vdot(the_v,end_x_dash);

#declare tmp_x = end_x_dash.x + gamma*the_v.x*end_t_dash + the_v.x*(gamma-1)*v_dot_x/v_sq;
#declare tmp_y = end_x_dash.y + gamma*the_v.y*end_t_dash + the_v.y*(gamma-1)*v_dot_x/v_sq;
#declare tmp_z = end_x_dash.z + gamma*the_v.z*end_t_dash + the_v.z*(gamma-1)*v_dot_x/v_sq;
#declare end_location = <tmp_x, tmp_y, tmp_z >;
#declare end_t = gamma*(end_t_dash + v_dot_x);

/* --- Lorentz transformation of viewing null vector --- */

#declare v_dot_w = vdot(the_v,w_dash);
#declare v_sq = beta*beta;

#declare tmp_x = w_dash.x + gamma*the_v.x*wt_dash + the_v.x*(gamma-1)*v_dot_x/v_sq;
#declare tmp_y = w_dash.y + gamma*the_v.y*wt_dash + the_v.y*(gamma-1)*v_dot_x/v_sq;
#declare tmp_z = w_dash.z + gamma*the_v.z*wt_dash + the_v.z*(gamma-1)*v_dot_x/v_sq;
#declare scene_look_at = <tmp_x, tmp_y, tmp_z >;

/* -------------------------------------------------------------------------- */

#declare displacement = end_location - beg_location;

#declare camera_velocity = the_v;

// Note all camera parameters, apart from velocity, refer to a momentarily 
// stationary camera in the scene frame. They thus describe rest properties 
// of the camera.

camera {
  velocity   camera_velocity
  location   beg_location + clock*displacement
  sky        < 0.0, 0.0, 1.0>    // right handed-system 
  up         < 0.0, 0.0, 1.0>    // Z is up, y out of screen, x points left
  right      < 1.33, 0.0, 0.0>   // Default width to height ratio
  angle      70.0000             // approximately a 28 mm lens
  look_at    scene_look_at       // far away so camera points in one direction
                                 // throughout its journey
}

//
// *******  L I G H T S *******
//

light_source {   // P_Light01
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <678.418335, -104.387993, 286.33551>
}

light_source {   // P_Light02
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <198.556122, 283.357605, 286.33551>
}


//
// ********  MATERIALS  *******
//

#include "source/choochoo_x.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#include "source/choochoo_p.inc"

#declare P_track_Ref = object {
  P_track
}
#declare P_pistons_Ref = object {
  P_pistons
}
#declare P_wheels_tfr_Ref = object {
  P_wheels_tfr
}
#declare P_wheels_tbk_Ref = object {
  P_wheels_tbk
}
#declare P_wheels_frt_Ref = object {
  P_wheels_frt
}
#declare P_wheels_mid_Ref = object {
  P_wheels_mid
}
#declare P_wheels_bk_Ref = object {
  P_wheels_bk
}
#declare P_trucks_ten_Ref = object {
  P_trucks_ten
}
#declare P_drive_Ref = object {
  P_drive
}
#declare P_drive_rdbt_Ref = object {
  P_drive_rdbt
}
#declare P_drive_btm_Ref = object {
  P_drive_btm
}
#declare P_drive_top_Ref = object {
  P_drive_top
}
#declare P_drive_rdtp_Ref = object {
  P_drive_rdtp
}
#declare P_axle_Ref = object {
  P_axle
}
#declare P_axle02_Ref = object {
  P_axle02
}
#declare P_axle03_Ref = object {
  P_axle03
}
#declare P_tender_Ref = object {
  P_tender
}
#declare P_pilot_Ref = object {
  P_pilot
}
#declare P_cab_Ref = object {
  P_cab
}
#declare P_boiler_Ref = object {
  P_boiler
}
#declare P_bell_Ref = object {
  P_bell
}
#declare P_tender01_Ref = object {
  P_tender01
}
#declare P_tender02_Ref = object {
  P_tender02
}
#declare P_tender03_Ref = object {
  P_tender03
}
#declare P_furnace_Ref = object {
  P_furnace
}
#declare P_hatch_Ref = object {
  P_hatch
}
#declare P_lever_Ref = object {
  P_lever
}
#declare P_gauges_Ref = object {
  P_gauges
}
#declare P_needle_Ref = object {
  P_needle
}
#declare P_needle01_Ref = object {
  P_needle01
}
#declare P_boiler01_Ref = object {
  P_boiler01
}
#declare P_cab01_Ref = object {
  P_cab01
}
#declare P_flaggs_Ref = object {
  P_flaggs
}
union { // choochoo_group
//  object { P_track_Ref }
  object { P_pistons_Ref }
  object { P_wheels_tfr_Ref }
  object { P_wheels_tbk_Ref }
  object { P_wheels_frt_Ref }
  object { P_wheels_mid_Ref }
  object { P_wheels_bk_Ref }
  object { P_trucks_ten_Ref }
  object { P_drive_Ref }
  object { P_drive_rdbt_Ref }
  object { P_drive_btm_Ref }
  object { P_drive_top_Ref }
  object { P_drive_rdtp_Ref }
  object { P_axle_Ref }
  object { P_axle02_Ref }
  object { P_axle03_Ref }
  object { P_tender_Ref }
  object { P_pilot_Ref }
  object { P_cab_Ref }
  object { P_boiler_Ref }
  object { P_bell_Ref }
  object { P_tender01_Ref }
  object { P_tender02_Ref }
  object { P_tender03_Ref }
  object { P_furnace_Ref }
  object { P_hatch_Ref }
  object { P_lever_Ref }
  object { P_gauges_Ref }
  object { P_needle_Ref }
  object { P_needle01_Ref }
  object { P_boiler01_Ref }
  object { P_cab01_Ref }
  object { P_flaggs_Ref }
  translate  <-238.027405, -69.988182, 0>
  rotate z*180
}
